/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.codegen;

import nuts.exts.mybatis.MyBatisModelDAO;

import freemarker.template.Configuration;

/**
 * model source generator
 */
public class MyBatisModelGenerator extends IBatisModelGenerator {
	/**
	 * Main class for ModelGenerator
	 */
	public static class Main extends IBatisModelGenerator.Main {
		/**
		 * @param args arguments
		 */
		public static void main(String[] args) {
			Main cgm = new Main();
			
			AbstractCodeGenerator cg = new MyBatisModelGenerator();

			cgm.execute(cg, args);
		}
	}

	@Override
	protected void loadTemplates(Configuration cfg) throws Exception {
		loadTemplates(cfg, "mybatis");
	}
	
	@Override
	protected void loadSqlmapTemplate(String dbtype) throws Exception {
		tplModelSqlmapXml = loadTemplate(ftlConfig, "mybatis/" + dbtype, "Model-sqlmap.xml.ftl");
	}

	@SuppressWarnings("rawtypes")
	@Override
	protected Class getBaseModelDAOClass() {
		return MyBatisModelDAO.class;
	}
}
