/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.vfs.ngfs.provider;

import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.cache.LRUFilesCache;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;

/**
 * gae file system manager
 */
public class GaeFileSystemManager extends StandardFileSystemManager {

	private static final String CONFIG_RESOURCE = "providers.xml";

	/**
	 * init
	 */
	public void init() throws FileSystemException {
		setFilesCache(new LRUFilesCache(1000));
		setCacheStrategy(CacheStrategy.MANUAL);
        setConfiguration(StandardFileSystemManager.class.getResource(CONFIG_RESOURCE));
		super.init();
	}
}
