/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.vfs.ngfs;

import nuts.core.dao.restriction.BooleanRestriction;
import nuts.core.dao.restriction.ComparableRestriction;
import nuts.core.dao.restriction.LikeableRestriction;
import nuts.exts.vfs.ndfs.dao.NdfsFileExample;
import nuts.gae.dao.GaeQueryParameter;

import java.util.Date;

import com.google.appengine.api.datastore.Query;

/**
 * GaeFileExample
 */
@SuppressWarnings("serial")
public class GaeFileExample extends GaeQueryParameter implements NdfsFileExample {
	/**
	 * Constructor
	 */
	public GaeFileExample() {
		super();
		setQuery(new Query(GaeFileMetaData.TABLE_NAME));
	}

	/**
	 * append AND
	 * @return this
	 */
	public GaeFileExample and() {
		getConditions().and();
		return this;
	}

	//----------------------------------------------------------------------
	// ALL exclude & include
	//----------------------------------------------------------------------
	/**
	 * excludeALL
	 * @return this
	 */
	public GaeFileExample excludeALL() {
	 	addExclude(GaeFileMetaData.PN_ID);
	 	addExclude(GaeFileMetaData.PN_PARENT_ID);
	 	addExclude(GaeFileMetaData.PN_NAME);
	 	addExclude(GaeFileMetaData.PN_FOLDER);
	 	addExclude(GaeFileMetaData.PN_LENGTH);
	 	addExclude(GaeFileMetaData.PN_LAST_MODIFIED);
	 	addExclude(GaeFileMetaData.PN_HIDDEN);
	 	addExclude(GaeFileMetaData.PN_READABLE);
	 	addExclude(GaeFileMetaData.PN_WRITEABLE);
		return this;
	}

	/**
	 * includeALL
	 * @return this
	 */
	public GaeFileExample includeALL() {
		clearExcludes();
		return this;
	}

	//----------------------------------------------------------------------
	// column restrictions
	//----------------------------------------------------------------------
	/**
	 * @return restriction of id
	 */
	public ComparableRestriction<NdfsFileExample, Long> id() {
		return new ComparableRestriction<NdfsFileExample, Long>(this, GaeFileMetaData.PN_ID);
	}

	/**
	 * @return restriction of parentId
	 */
	public ComparableRestriction<NdfsFileExample, Long> parentId() {
		return new ComparableRestriction<NdfsFileExample, Long>(this, GaeFileMetaData.PN_PARENT_ID);
	}

	/**
	 * @return restriction of name
	 */
	public LikeableRestriction<NdfsFileExample, String> name() {
		return new LikeableRestriction<NdfsFileExample, String>(this, GaeFileMetaData.PN_NAME);
	}

	/**
	 * @return restriction of folder
	 */
	public BooleanRestriction<NdfsFileExample> folder() {
		return new BooleanRestriction<NdfsFileExample>(this, GaeFileMetaData.PN_FOLDER);
	}

	/**
	 * @return restriction of length
	 */
	public ComparableRestriction<NdfsFileExample, Long> length() {
		return new ComparableRestriction<NdfsFileExample, Long>(this, GaeFileMetaData.PN_LENGTH);
	}

	/**
	 * @return restriction of lastModified
	 */
	public ComparableRestriction<NdfsFileExample, Date> lastModified() {
		return new ComparableRestriction<NdfsFileExample, Date>(this, GaeFileMetaData.PN_LAST_MODIFIED);
	}

	/**
	 * @return restriction of hidden
	 */
	public BooleanRestriction<NdfsFileExample> hidden() {
		return new BooleanRestriction<NdfsFileExample>(this, GaeFileMetaData.PN_HIDDEN);
	}

	/**
	 * @return restriction of readable
	 */
	public BooleanRestriction<NdfsFileExample> readable() {
		return new BooleanRestriction<NdfsFileExample>(this, GaeFileMetaData.PN_READABLE);
	}

	/**
	 * @return restriction of writeable
	 */
	public BooleanRestriction<NdfsFileExample> writeable() {
		return new BooleanRestriction<NdfsFileExample>(this, GaeFileMetaData.PN_WRITEABLE);
	}
}

