/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.vfs.ngfs;

import nuts.core.dao.DaoException;
import nuts.core.dao.DaoSession;
import nuts.exts.vfs.ndfs.dao.NdfsData;
import nuts.exts.vfs.ndfs.dao.NdfsDataDAO;
import nuts.gae.dao.GaeModelDAO;

/**
 */
public class GaeDataDAO extends GaeModelDAO<NdfsData, GaeDataExample> implements NdfsDataDAO<NdfsData, GaeDataExample> {

	/**
	 * Constructor
	 */
	public GaeDataDAO() {
		super();
	}

	/**
	 * Constructor
	 *
	 * @param dataAccessSession the dataAccessSession to set
	 */
	public GaeDataDAO(DaoSession dataAccessSession) {
		super(dataAccessSession);
	}

	/**
	 * create example
	 * @return example instance
	 */
	public GaeDataExample createExample() {
		return new GaeDataExample();
	}

	/**
	 * @return model id
	 */
	public String getModelId() {
		return GaeDataMetaData.TABLE_NAME;
	}
	
	/**
	 * exists
	 * 
	 * @param id id
	 * @return true if exists
	 * @throws DaoException if a data access error occurs
	 */ 
	public boolean exists(Long id) throws DaoException {
		NdfsData key = new NdfsData();
		key.setId(id);
		return exists(key);
	}
	
	/**
	 * selectByPrimaryKey
	 * 
	 * @param id id
	 * @return NdfsFileData
	 * @throws DaoException if a data access error occurs
	 */ 
	public NdfsData selectByPrimaryKey(Long id) throws DaoException {
		NdfsData key = new NdfsData();
		key.setId(id);
		return fetch(key);
	}

	/**
	 * deleteByPrimaryKey
	 * 
	 * @param id id
	 * @return count of deleted records
	 * @throws DaoException if a data access error occurs
	 */ 
	public int deleteByPrimaryKey(Long id) throws DaoException {
		NdfsData key = new NdfsData();
		key.setId(id);
		return delete(key);
	}
}
