/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.dao;

import nuts.core.dao.Conditions;
import nuts.core.dao.Orders;
import nuts.core.dao.SimpleQueryParameter;

import com.google.appengine.api.datastore.Query;

/**
 */
@SuppressWarnings("serial")
public class GaeQueryParameter extends SimpleQueryParameter {
	private Query query;
	
	/**
	 * Constructor
	 */
	public GaeQueryParameter() {
		super();
	}

	/**
	 * @return the query
	 */
	public Query getQuery() {
		return query;
	}

	/**
	 * @param query the query to set
	 */
	public void setQuery(Query query) {
		this.query = query;
	}

	/**
	 * @return conditions
	 */
	public Conditions getConditions() {
		if (conditions == null) {
			conditions = new GaeConditions(query);
		}
		return conditions;
	}

	/**
	 * @return conditions
	 */
	public GaeConditions getGaeConditions() {
		return (GaeConditions)getConditions();
	}

	/**
	 * @return orders
	 */
	public Orders getOrders() {
		if (orders == null) {
			orders = new GaeOrders(query);
		}
		return orders;
	}

	/**
	 * @return orders
	 */
	public GaeOrders getGaeOrders() {
		return (GaeOrders)getOrders();
	}
}
