/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.gae.dao;

import nuts.core.castor.Castors;
import nuts.core.dao.AbstractDataAccessClient;
import nuts.core.dao.DaoSession;

import java.util.Properties;

import com.google.appengine.api.datastore.DatastoreService;

/**
 */
public class GaeDataAccessClient extends AbstractDataAccessClient implements DatastoreServiceAware {
	
	private Castors castors = Castors.me();
	private DatastoreService datastoreService;
	
	/**
	 */
	public GaeDataAccessClient() {
		super();
	}

	/**
	 * @param datastoreService the datastoreService to set
	 */
	public GaeDataAccessClient(DatastoreService datastoreService, Properties props) {
		super(props);
		this.datastoreService = datastoreService;
	}

	public Castors getCastors() {
		return castors;
	}

	public void setCastors(Castors castors) {
		this.castors = castors;
	}

	/**
	 * @return the datastoreService
	 */
	public DatastoreService getDatastoreService() {
		return datastoreService;
	}

	/**
	 * @param datastoreService the datastoreService to set
	 */
	public void setDatastoreService(DatastoreService datastoreService) {
		this.datastoreService = datastoreService;
	}

	/**
	 * open session
	 * @return DataAccessSession
	 */
	public DaoSession openSession(boolean autoCommit) {
		return new GaeDataAccessSession(this, datastoreService, autoCommit);
	}

}
