/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.flex.controls {
    import flash.events.Event;
    import flash.external.ExternalInterface;
    import flash.geom.Point;
    
    import mx.containers.Canvas;
    import mx.events.FlexEvent;
    import mx.events.MoveEvent;
    import mx.events.ResizeEvent;

	public class IFrame extends Canvas {
       /**
        * Here we define javascript functions which will be inserted into the DOM
        * 
        */
        private static var FUNCTION_CREATEIFRAME:String = 
            "document.insertScript = function() {" +
                "if (document.nuts_createIFrame == null) {" + 
                    "nuts_createIFrame = function(id) {" +
                        "var div = document.createElement('div');" +
                        "div.id = id;" +
                        "div.style.position ='absolute';" +
                        "div.style.backgroundColor = 'transparent';" + 
                        "div.style.border = '0px';" +
                        "div.style.top = '-9999px';" +
                        "div.style.left = '-9999px';" +
                        "div.style.width = '0px';" +
                        "div.style.height = '0px';" +
                        "document.body.appendChild(div);" +
                    "}" +
                "}" +
            "}";
        
        private static var FUNCTION_MOVEIFRAME:String = 
            "document.insertScript = function() {" +
	            "if (document.nuts_moveIFrame == null) {" +
	                "nuts_moveIFrame = function(id, x, y, w, h) {" + 
	                    "var div = document.getElementById(id);" +
	                    "div.style.left = x;" + 
	                    "div.style.top = y;" +
	                    "div.style.width = w;" + 
	                    "div.style.height = h;" +
	                    "var iframe = div.firstChild;" +
	                	"iframe.width = w;" +
	                	"iframe.height = h;" +
		            "}" +
                "}" +
            "}";

        private static var FUNCTION_HIDEIFRAME:String = 
            "document.insertScript = function() {" +
	            "if (document.nuts_hideIFrame == null) {" +
	                "nuts_hideIFrame = function(id) {" +
                        "document.getElementById(id).style.visibility = 'hidden';" +
                    "}" +
                "}" +
            "}";

        private static var FUNCTION_SHOWIFRAME:String = 
            "document.insertScript = function() {" +
	            "if (document.nuts_showIFrame == null) {" +
	                "nuts_showIFrame = function(id) {" +
                        "document.getElementById(id).style.visibility = 'visible';" +
                    "}" +
                "}" +
            "}";

        private static var FUNCTION_LOADIFRAME:String = 
            "document.insertScript = function() {" +
	            "if (document.nuts_loadIFrame == null) {" +
	                "nuts_loadIFrame = function(id, url) {" +
                        "document.getElementById(id).innerHTML = \"<iframe src='\" + url + \"' frameborder='0'></iframe>\";" +
                    "}" +
                "}" +
            "}";
        
        
		private static var _init:Boolean = false; 
		private static var _sequence:int = 0;

        private var _frameId:String;
        private var _source: String;

		public function IFrame() {
			super();
			
			if (!_init) {
	            // Add functions to DOM if they aren't already there
	            ExternalInterface.call(FUNCTION_CREATEIFRAME);
	            ExternalInterface.call(FUNCTION_MOVEIFRAME);
	            ExternalInterface.call(FUNCTION_HIDEIFRAME);
	            ExternalInterface.call(FUNCTION_SHOWIFRAME);
	            ExternalInterface.call(FUNCTION_LOADIFRAME);
	            
	            _init = true;
			}

			this.addEventListener(ResizeEvent.RESIZE, onResize);
			this.addEventListener(MoveEvent.MOVE, onMove);
			this.addEventListener(FlexEvent.INITIALIZE, onInit);
		}
		
		private function onResize(event:ResizeEvent):void {
			callLater(moveIFrame);
		} 

		private function onMove(event:MoveEvent):void {
			callLater(moveIFrame);
		}	

		private function onInit(event:FlexEvent):void {
            callLater(moveIFrame);
		}

		private function createIFrame():void {
			if (_frameId == null) {
	            // Generate unique id's for frame div name
	            _sequence++;
	            _frameId = id + _sequence;
	
	            // Insert frame into DOM using our precreated function 'createIFrame'
	            ExternalInterface.call("nuts_createIFrame", _frameId);
			}
		}
			
        /**
         * Move iframe through ExternalInterface.  The location is determined using localToGlobal()
         * on a Point in the Canvas.
         **/
        private function moveIFrame(event:Event=null):void {
        	if (_frameId != null && !isNaN(width) && !isNaN(height)) {
	            var localPt:Point = new Point(0, 0);
	            var globalPt:Point = this.localToGlobal(localPt);
	
	            ExternalInterface.call("nuts_moveIFrame", _frameId, globalPt.x, globalPt.y, width, height);
        	}
		}

        /**
         * The source URL for the IFrame.  When set, the URL is loaded through ExternalInterface.
         **/
        public function set source(value:String):void {
            if (value) {
                _source = value;
            	createIFrame();
                ExternalInterface.call("nuts_loadIFrame", _frameId, _source);
                moveIFrame();
            }
        }

        public function get source(): String {
            return _source;
        }

        /**
         * Whether the IFrame is visible.  
         **/
        override public function set visible(value:Boolean):void {
            super.visible = value;

            if (value) {
                ExternalInterface.call("nuts_showIFrame", _frameId);
            }
            else {
                ExternalInterface.call("nuts_hideIFrame", _frameId);
            }
        }
    }
}

