/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import nuts.core.bind.json.Jsons;
import nuts.exts.struts2.test.ActionTestCase;
import nuts.exts.struts2.test.TestAction;
import nuts.exts.struts2.test.TestBean;

import java.util.HashMap;
import java.util.Map;

import com.opensymphony.xwork2.ActionProxy;

/**
 * ConstantFieldValidatorTest
 * @see ConstantFieldValidator
 */
public class ConstantFieldValidatorTest extends ActionTestCase {
	protected void doSuccessTest(String action, char v) throws Exception {
		TestBean tbd = new TestBean();

		Map<String, String> rps = new HashMap<String, String>();

		tbd.setCharField(v);
		tbd.setDataToMap(rps, "bean.");

		ActionProxy proxy = createActionProxy("/test", action, null, rps);

		assertTrue(proxy.getAction() instanceof TestAction);

		// Run the Struts Interceptor stack and the Action
		String result = proxy.execute();

		// Check the results
		assertEquals(TestAction.SUCCESS, result);

		String rc = getResponseContentAsString();

		Map rjo = Jsons.fromJson(rc, HashMap.class);
		assertEquals(Boolean.TRUE, rjo.get("success"));
	}

	protected void doErrorTest(String action, char v) throws Exception {
		TestBean tbd = new TestBean();

		Map<String, String> rps = new HashMap<String, String>();

		tbd.setCharField(v);
		tbd.setDataToMap(rps, "bean.");

		ActionProxy proxy = createActionProxy("/test", action, null, rps);

		assertTrue(proxy.getAction() instanceof TestAction);

		// Run the Struts Interceptor stack and the Action
		String result = proxy.execute();

		// Check the results
		assertEquals(TestAction.INPUT, result);

		String rc = getResponseContentAsString();

		Map rjo = Jsons.fromJson(rc, HashMap.class);
		assertEquals(Boolean.FALSE, rjo.get("success"));

		Map fes = (Map)rjo.get("fieldErrors");
		assertNotNull(fes);
		assertTrue(fes.containsKey("bean.charField"));
	}

	/**
	 * @throws Exception if an error occurs
	 */
	public void test001() throws Exception {
		doSuccessTest("constantsvalidate", 'A');
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void test002() throws Exception {
		doErrorTest("constantsvalidate", 'c');
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void test003() throws Exception {
		doSuccessTest("constantsvalidate2", 'A');
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void test004() throws Exception {
		doErrorTest("constantsvalidate2", 'c');
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void test005() throws Exception {
		doSuccessTest("constantsvalidate3", 'A');
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void test006() throws Exception {
		doErrorTest("constantsvalidate3", 'c');
	}
}
