/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views;

import nuts.exts.struts2.test.ActionTestCase;

import java.util.HashMap;
import java.util.Map;

/**
 * Test Boolean Tag
 * @see nuts.exts.struts2.components.CBoolean
 */
public class BooleanTagTest extends ActionTestCase {

	private void doTest(String format, Boolean value, String expected) throws Exception {
		Map<String, String> params = new HashMap<String, String>();
		
		params.put("bean.booleanField", value.toString());
		
		doRequest("/test/booltagtest_" + format, params);

		String rc = getResponseContentAsString();

		assertEquals(expected, rc);
	}

	/**
	 * test choice format - true
	 * @throws Exception if an error occurs
	 */
	public void testChoiceTrue() throws Exception {
		doTest("choice", true, "YES");
	}

	/**
	 * test choice format - false
	 * @throws Exception if an error occurs
	 */
	public void testChoiceFalse() throws Exception {
		doTest("choice", false, "NO");
	}

	/**
	 * test ognl format - true
	 * @throws Exception if an error occurs
	 */
	public void testOgnlTrue() throws Exception {
		doTest("ognl", true, "TRUE");
	}

	/**
	 * test ognl format - false
	 * @throws Exception if an error occurs
	 */
	public void testOgnlFalse() throws Exception {
		doTest("ognl", false, "FALSE");
	}

}
