/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
if (typeof(nuts) == "undefined") { nuts = {}; }

(function() {
	function setContentType($p, t) {
		if (t == 'error') {
			if (!$p.hasClass('n-error-content')) {
				$p.addClass('n-error-content').removeClass('n-warning-content n-confirm-content n-message-content');
			}
		}
		else if (t == 'warning') {
			if (!$p.hasClass('n-error-content')
				&& !$p.hasClass('n-warning-content')) {
				$p.addClass('n-warning-content').removeClass('n-confirm-content n-message-content');
			}
		}
		else if (t == 'confirm') {
			if (!$p.hasClass('n-error-content') 
				&& !$p.hasClass('n-warning-content')
				&& !$p.hasClass('n-confirm-content')) {
				$p.addClass('n-confirm-content').removeClass('n-message-content');
			}
		}
		else {
			if (!$p.hasClass('n-error-content') 
				&& !$p.hasClass('n-warning-content') 
				&& !$p.hasClass('n-confirm-content')
				&& !$p.hasClass('n-message-content')) {
				$p.addClass('n-message-content');
			}
		}
	}
	
	function addMsg($p, s, m, t) {
		var c = s.baseCls + '-' + t;
		var ic = s.icons[t] + ' ' + c;
		$p.append('<ul class="' + c + 's"><li class="' + c + '"><img class="' + ic + '" src="' + s.blankImg + '">' + m + '</li></ul>');
		setContentType($p, t);
	}

	function addMsgs($p, s, m, t) {
		if (m) {
			var c = s.baseCls + '-' + t;
			var ic = s.icons[t] + ' ' + c;
			var h = '<ul class="' + c + 's">';
			if ($.isArray(m)) {
				for (var i = 0; i < m.length; i++) {
					h += '<li class="' + c + '"><img class="' + ic + '" src="' + s.blankImg + '">' + m[i] + '</li>';
				}
			}
			else {
				for (var n in m) {
					var v = m[n];
					for (var i = 0; i < v.length; i++) {
						h += '<li class="' + c + '"><img class="' + ic + '" src="' + s.blankImg + '">' + v[i] + '</li>';
					}
				}
			}
			h += '</ul>';
			$p.append(h);
			setContentType($p, t);
		}
	}
	
	nuts.prompt = function(s) {
		if (typeof(s) == 'string') {
			s = { container: s };
		}
		s = $.extend({}, nuts.prompt.defaults, s);
		return {
			clear: function() {
				$(s.container).children('.' + s.baseCls + '-prompt').remove();
				return this;
			},
			error: function(m) {
				this.add(m, 'error');
				return this;
			},
			warning: function(m) {
				this.add(m, 'warning');
				return this;
			},
			confirm: function(m) {
				this.add(m, 'confirm');
				return this;
			},
			message: function(m) {
				this.add(m, 'message');
				return this;
			},
			add: function(m, t) {
				t = t || 'message';
				var $c = $(s.container);
				var $p = $c.children('.' + s.baseCls + '-prompt');
				var a = false;
				if ($p.size() < 1) {
					$p = $('<div></div>').addClass(s.baseCls + '-prompt').css('display', 'none');
					$c.prepend($p);
					a = true;
				}
				
				if (typeof(m) == 'string') {
					addMsg($p, s, m, t);
				}
				else if ($.isArray(m)) {
					for (var i = 0; i < m.length; i++) {
						if (typeof(m[i]) == 'string') {
							addMsg($p, s, m[i], t);
						}
						else {
							addMsg($p, s, m[i].html, m[i].type);
						}
					}
				}
				else if (m) {
					addMsgs($p, s, m.actionErrors, "error");
					addMsgs($p, s, m.fieldErrors, "error");
					addMsgs($p, s, m.actionWarnings, "warning");
					addMsgs($p, s, m.actionConfirms, "confirm");
					addMsgs($p, s, m.actionMessages, "message");
				}
				
				if (a) { 
					$p.slideDown();
				}
				return this;
			}
		}
	};
	
	nuts.prompt.defaults = {
		baseCls: 'n-action',
		blankImg: '/static/nuts/images/s.gif',
		container: 'body',
		icons: {
			'confirm': 'n-icon n-icon-help',
			'message': 'n-icon n-icon-informaton',
			'error': 'n-icon n-icon-error',
			'warning': 'n-icon n-icon-warning'
		}
	};
		
	nuts.prompt.toggleFieldErrors = function(el) {
		var $fes = $(el).closest('.n-action-errors').next('div.n-field-errors');
		if ($fes.is(':hidden')) {
			$fes.slideDown();
			$(el).children('img').removeClass('ui-icon-triangle-1-e').addClass('ui-icon-triangle-1-s');
		}
		else {
			$fes.slideUp();
			$(el).children('img').removeClass('ui-icon-triangle-1-s').addClass('ui-icon-triangle-1-e');
		}
		return false;
	};
})();
