/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
(function($) {
	if ($.datepicker) {
		var _parseDate = $.datepicker.parseDate;
		$.datepicker.parseDate = function(format, value, settings) {
			if (format instanceof DateFormat) {
				return format.parse(value);
			}
			else {
				return _parseDate.call(this, format, value, settings);
			}
		};
		
		var _formatDate = $.datepicker.formatDate;
		$.datepicker.formatDate = function(format, date, settings) {
			if (format instanceof DateFormat) {
				return format.format(date);
			}
			else {
				return _formatDate.call(this, format, date, settings);
			}
		};
	}
})(jQuery);
