/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import nuts.exts.fileupload.UploadFile;

import java.io.File;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

import com.opensymphony.xwork2.validator.ValidationException;

/**
 * RequiredFileFieldValidator
 */
public class RequiredFileFieldValidator extends AbstractFieldValidator {

	/**
	 * @see com.opensymphony.xwork2.validator.Validator#validate(java.lang.Object)
	 */
	public void validate(Object object) throws ValidationException {
		Object value = getFieldValue(getFieldName(), object);

		if (value instanceof UploadFile) {
			value = ((UploadFile)value).getFile();
		}

		if (value == null) {
			addFieldError(getFieldName(), object);
			return;
		}

		if (value instanceof File) {
			File f = (File)value;

			if (!f.exists() || !f.isFile()) {
				addFieldError(getFieldName(), object);
			}
		}
		else if (value instanceof FileObject) {
			FileObject f = (FileObject)value;

			try {
				if (!f.exists() || !FileType.FILE.equals(f.getType())) {
					addFieldError(getFieldName(), object);
				}
			}
			catch (FileSystemException e) {
				throw new ValidationException("field [" + getFieldName() + "] ("
						+ value.getClass() + ") ERROR: " + e.getMessage());
			}
		}
		else {
			throw new ValidationException("field [" + getFieldName() + "] ("
					+ value.getClass() + ") is not a instance of "
					+ File.class.getName() + " / " + FileObject.class.getName());
		}
	}
}
