/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import nuts.core.image.ImageWrapper;
import nuts.core.image.Images;
import nuts.core.image.JavaImageWrapper;
import nuts.core.io.Streams;
import nuts.exts.fileupload.UploadFile;
import nuts.exts.fileupload.UploadImage;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.vfs2.FileObject;

import com.opensymphony.xwork2.validator.ValidationException;

/**
 * image size field validator.
 */
public class ImageFieldValidator extends AbstractFieldValidator {

	protected ImageWrapper getImage(Object value) throws ValidationException {
		ImageWrapper img = null;
		try {
			if (value == null) {
			}
			else if (value instanceof byte[]) {
				img = Images.me().makeImage((byte[])value);
			}
			else if (value instanceof InputStream) {
				byte[] data = Streams.toByteArray((InputStream)value);
				img = Images.me().makeImage(data);
			}
			else if (value instanceof BufferedImage) {
				img = new JavaImageWrapper((BufferedImage)value);
			}
			else if (value instanceof ImageWrapper) {
				img = (ImageWrapper)value;
			}
			else if (value instanceof URL) {
				byte[] data = Streams.toByteArray((URL)value);
				img = Images.me().makeImage(data);
			}
			else if (value instanceof File) {
				File f = (File)value;
				if (f.exists() && f.isFile()) {
					byte[] data = Streams.toByteArray(f);
					img = Images.me().makeImage(data);
				}
			}
			else if (value instanceof FileObject) {
				FileObject f = (FileObject)value;
				if (f.exists()) {
					byte[] data = Streams.toByteArray(f);
					img = Images.me().makeImage(data);
				}
			}
			else if (value instanceof UploadImage) {
				img = ((UploadImage)value).getImage();
			}
			else if (value instanceof UploadFile) {
				byte[] data = ((UploadFile)value).getData();
				if (data != null) {
					img = Images.me().makeImage(data);
				}
			}
			else {
				throw new ValidationException("The value type of [" + getFieldName() + "] is invalid. (only RenderedImage/byte[]/File/URL/InputStream is allowed)");
			}
		}
		catch (Exception e) {
			log.warn("Failed to read image of [" + getFieldName() + "]", e);
		}
		return img;
	}
	
	/**
	 * @see com.opensymphony.xwork2.validator.Validator#validate(java.lang.Object)
	 */
	public void validate(Object object) throws ValidationException {
		Object value = getFieldValue(getFieldName(), object);

		if (value == null) {
			return;
		}
		else if (value instanceof UploadFile) {
			byte[] data;
			try {
				data = ((UploadFile)value).getData();
				if (data == null) {
					return;
				}
			}
			catch (Exception e) {
				return;
			}

			try {
				value = Images.me().makeImage(data);
			}
			catch (Exception e) {
				addFieldError(getFieldName(), object);
			}
		}
		
		if (getImage(value) == null) {
			addFieldError(getFieldName(), object);
		}
	}
}
