/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import nuts.core.lang.Strings;

import com.opensymphony.xwork2.validator.ValidationException;

/**
 * BinaryLengthFieldValidator
 */
public class BinaryLengthFieldValidator extends AbstractFieldValidator {

	private Integer minLength = null;
	private Integer maxLength = null;
	private Integer length = null;
	
    /**
	 * @return the maxLength
	 */
	public Integer getMaxLength() {
		return maxLength;
	}

	/**
	 * @param maxLength the maxLength to set
	 */
	public void setMaxLength(Integer maxLength) {
		this.maxLength = maxLength;
	}

	/**
	 * @return the minLength
	 */
	public Integer getMinLength() {
		return minLength;
	}

	/**
	 * @param minLength the minLength to set
	 */
	public void setMinLength(Integer minLength) {
		this.minLength = minLength;
	}

	/**
	 * @return the length
	 */
	public Integer getLength() {
		return length;
	}


	/**
	 * @return minBinSize
	 */
	public String getMinBinSize() {
		return Strings.formatFileSize(minLength);
	}
	
	/**
	 * @return maxBinSize
	 */
	public String getMaxBinSize() {
		return Strings.formatFileSize(maxLength);
	}
	
	/**
	 * @return BinSize
	 */
	public String getBinSize() {
		return Strings.formatFileSize(length);
	}
	
	/**
	 * @see com.opensymphony.xwork2.validator.Validator#validate(java.lang.Object)
	 */
	public void validate(Object object) throws ValidationException {
        Object value = getFieldValue(getFieldName(), object);

        if (value == null) {
        	return;
        }
        
        if (!(value instanceof byte[])) {
        	throw new ValidationException("field [" + getFieldName() + "] (" + value.getClass() + ") is not a instance of " + byte[].class);
        }
        
        byte[] b = (byte[])value;
        
        length = b.length;
        
        // only check for a minimum value if the min parameter is set
        if (minLength != null && length < minLength) {
            addFieldError(getFieldName(), object);
            return;
        }

        // only check for a maximum value if the max parameter is set
        if (maxLength != null && length > maxLength) {
            addFieldError(getFieldName(), object);
            return;
        }
    }
}
