/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2;

import nuts.exts.xwork2.util.LocalizedTextUtils;

import java.util.List;
import java.util.Map;

/**
 * TextProviderSupport
 */
public class TextProviderSupport extends com.opensymphony.xwork2.TextProviderSupport implements TextProvider {
	/**
	 * getTextAsBoolean
	 * @param name resource name
	 * @return boolean value
	 */
	public Boolean getTextAsBoolean(String name) {
		return getTextAsBoolean(name, null);
	}

	/**
	 * getTextAsBoolean
	 * @param name resource name
	 * @param defaultValue default value
	 * @return boolean value
	 */
	public Boolean getTextAsBoolean(String name, Boolean defaultValue) {
		String s = getText(name, (String)null);
		return s == null ? defaultValue : Boolean.valueOf(s);
	}

	/**
	 * getTextAsInt
	 * @param name resource name
	 * @return integer value
	 */
	public Integer getTextAsInt(String name) {
		return getTextAsInt(name, null);
	}

	/**
	 * getTextAsInt
	 * @param name resource name
	 * @param defaultValue default value
	 * @return integer value
	 */
	public Integer getTextAsInt(String name, Integer defaultValue) {
		String s = getText(name, (String)null);
		return s == null ? defaultValue : Integer.valueOf(s);
	}

	/**
	 * getTextAsLong
	 * @param name resource name
	 * @return long value
	 */
	public Long getTextAsLong(String name) {
		return getTextAsLong(name, null);
	}

	/**
	 * getTextAsLong
	 * @param name resource name
	 * @param defaultValue default value
	 * @return long value
	 */
	public Long getTextAsLong(String name, Long defaultValue) {
		String s = getText(name, (String)null);
		return s == null ? defaultValue : Long.valueOf(s);
	}

	/**
	 * getTextAsList
	 * @param name resource name
	 * @return List value
	 */
	public List getTextAsList(String name) {
		return getTextAsList(name, null);
	}
	
	/**
	 * getTextAsList
	 * @param name resource name
	 * @param defaultValue default value
	 * @return list value
	 */
	public List getTextAsList(String name, List defaultValue) {
		String expr = getText(name, (String)null);
		return LocalizedTextUtils.parseTextAsList(expr, defaultValue);
	}

	/**
	 * getTextAsMap
	 * @param name resource name
	 * @return map value
	 */
	public Map getTextAsMap(String name) {
		return getTextAsMap(name, null);
	}
	
	/**
	 * getTextAsMap
	 * @param name resource name
	 * @param defaultValue default value
	 * @return map value
	 */
	public Map getTextAsMap(String name, Map defaultValue) {
		String expr = getText(name, (String)null);
		return LocalizedTextUtils.parseTextAsMap(expr, defaultValue);
	}
}
