/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.vfs.ndfs.dao;

import nuts.core.dao.DaoException;
import nuts.core.dao.ModelDAO;

/**
 * NdfsFileDAO
 */
public interface NdfsFileDAO<T extends NdfsFile, E extends NdfsFileExample> extends ModelDAO<T, E> {

	/**
	 * create example
	 * @return example instance
	 */
	E createExample();

	/**
	 * @return model id
	 */
	String getModelId();
	
	/**
	 * exists
	 * 
	 * @param id id
	 * @return true if exists
	 * @throws DaoException if a data access error occurs
	 */ 
	boolean exists(Long id) throws DaoException;
	
	/**
	 * selectByPrimaryKey
	 * 
	 * @param id id
	 * @return NdfsFile
	 * @throws DaoException if a data access error occurs
	 */ 
	NdfsFile selectByPrimaryKey(Long id) throws DaoException;

	/**
	 * deleteByPrimaryKey
	 * 
	 * @param id id
	 * @return count of deleted records
	 * @throws DaoException if a data access error occurs
	 */ 
	int deleteByPrimaryKey(Long id) throws DaoException;
}
