/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.vfs.ndfs.dao;

import nuts.core.dao.QueryParameter;
import nuts.core.dao.restriction.ComparableRestriction;

/**
 */
public interface NdfsDataExample extends QueryParameter {
	/**
	 * append AND
	 * @return this
	 */
	NdfsDataExample and();

	//----------------------------------------------------------------------
	// ALL exclude & include
	//----------------------------------------------------------------------
	/**
	 * excludeALL
	 * @return this
	 */
	NdfsDataExample excludeALL();

	/**
	 * includeALL
	 * @return this
	 */
	NdfsDataExample includeALL();

	//----------------------------------------------------------------------
	// column restrictions
	//----------------------------------------------------------------------
	/**
	 * @return restriction of id
	 */
	ComparableRestriction<NdfsDataExample, Long> id();

	/**
	 * @return restriction of fileId
	 */
	ComparableRestriction<NdfsDataExample, Long> fileId();

	/**
	 * @return restriction of itemNo
	 */
	ComparableRestriction<NdfsDataExample, Integer> itemNo();
}

