/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.vfs;

import nuts.core.io.Files;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

import org.apache.commons.vfs2.FileObject;

public class FileObjectDataSource implements DataSource {
	private FileObject file;
	
	public FileObjectDataSource(FileObject file) {
		this.file = file;
	}

	public String getContentType() {
		return Files.getContentTypeFor(this.file.getName().toString());
	}

	public InputStream getInputStream() throws IOException {
		return file.getContent().getInputStream();
	}

	public String getName() {
		return file.getName().getBaseName();
	}

	public OutputStream getOutputStream() throws IOException {
		return file.getContent().getOutputStream();
	}
}
