/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.jsp.ui;

import nuts.exts.struts2.components.Pager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ui.AbstractUITag;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * @see Pager
 */
@SuppressWarnings("serial")
public class PagerTag extends AbstractUITag {

	// attributes
	protected String command;
	protected String start;
	protected String count;
	protected String limit;
	protected String total;

	protected String emptyText;
	protected String infoText;
	protected String firstText;
	protected String lastText;
	protected String prevText;
	protected String nextText;

	protected String linkHref;
	protected String linkSize;
	protected String linkStyle;
	protected String onLinkClick;

	protected String limitLabel;
	protected String limitName;
	protected Object limitList;
	protected String onLimitChange;

	/**
	 * @param start the start to set
	 */
	public void setStart(String start) {
		this.start = start;
	}

	/**
	 * @param count the count to set
	 */
	public void setCount(String count) {
		this.count = count;
	}

	/**
	 * @param command the command to set
	 */
	public void setCommand(String command) {
		this.command = command;
	}

	/**
	 * @param limit the limit to set
	 */
	public void setLimit(String limit) {
		this.limit = limit;
	}

	/**
	 * @param total the total to set
	 */
	public void setTotal(String total) {
		this.total = total;
	}

	/**
	 * @param emptyText the emptyText to set
	 */
	public void setEmptyText(String emptyText) {
		this.emptyText = emptyText;
	}


	/**
	 * @param infoText the infoText to set
	 */
	public void setInfoText(String infoText) {
		this.infoText = infoText;
	}

	/**
	 * @param firstText the firstText to set
	 */
	public void setFirstText(String firstText) {
		this.firstText = firstText;
	}

	/**
	 * @param lastText the lastText to set
	 */
	public void setLastText(String lastText) {
		this.lastText = lastText;
	}

	/**
	 * @param linkHref the linkHref to set
	 */
	public void setLinkHref(String linkHref) {
		this.linkHref = linkHref;
	}

	/**
	 * @param onLinkClick the onLinkClick to set
	 */
	public void setOnLinkClick(String onLinkClick) {
		this.onLinkClick = onLinkClick;
	}

	/**
	 * @param prevText the prevText to set
	 */
	public void setPrevText(String prevText) {
		this.prevText = prevText;
	}

	/**
	 * @param nextText the nextText to set
	 */
	public void setNextText(String nextText) {
		this.nextText = nextText;
	}

	/**
	 * @param linkSize the linkSize to set
	 */
	public void setLinkSize(String linkSize) {
		this.linkSize = linkSize;
	}

	/**
	 * @param linkStyle the linkStyle to set
	 */
	public void setLinkStyle(String linkStyle) {
		this.linkStyle = linkStyle;
	}

	/**
	 * @param limitLabel the limitLabel to set
	 */
	public void setLimitLabel(String limitLabel) {
		this.limitLabel = limitLabel;
	}

	/**
	 * @param limitName the limitName to set
	 */
	public void setLimitName(String limitName) {
		this.limitName = limitName;
	}

	/**
	 * @param limitList the limitList to set
	 */
	public void setLimitList(Object limitList) {
		this.limitList = limitList;
	}

	/**
	 * @param onLimitChange the onLimitChange to set
	 */
	public void setOnLimitChange(String onLimitChange) {
		this.onLimitChange = onLimitChange;
	}

	/**
	 * @see org.apache.struts2.views.jsp.ComponentTagSupport#getBean(com.opensymphony.xwork2.util.ValueStack,
	 *      javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		return new Pager(stack, req, res);
	}

	/**
	 * @see org.apache.struts2.views.jsp.ui.AbstractUITag#populateParams()
	 */
	protected void populateParams() {
		super.populateParams();

		Pager pager = ((Pager) component);
		pager.setStart(start);
		pager.setCount(count);
		pager.setLimit(limit);
		pager.setTotal(total);
		pager.setEmptyText(emptyText);
		pager.setInfoText(infoText);
		pager.setFirstText(firstText);
		pager.setLastText(lastText);
		pager.setPrevText(prevText);
		pager.setNextText(nextText);
		pager.setLinkHref(linkHref);
		pager.setLinkSize(linkSize);
		pager.setLinkStyle(linkStyle);
		pager.setLimitLabel(limitLabel);
		pager.setLimitName(limitName);
		pager.setLimitList(limitList);
		pager.setOnLimitChange(onLimitChange);
		pager.setOnLinkClick(onLinkClick);
	}

}
