/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.jsp.ui;

import nuts.exts.struts2.components.DatePicker;
import nuts.exts.struts2.components.DateTimePicker;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ui.AbstractUITag;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * DateTimePicker Tag.
 */
@SuppressWarnings("serial")
public class DateTimePickerTag extends AbstractUITag {

    protected String maxlength;
    protected String readonly;
    protected String size;
	protected String inline;
	protected String format;
	protected String pattern;
	protected String options;

	/**
	 * @see org.apache.struts2.views.jsp.ComponentTagSupport#getBean(com.opensymphony.xwork2.util.ValueStack,
	 *      javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		return new DateTimePicker(stack, req, res);
	}

	protected void populateParams() {
		super.populateParams();

		DatePicker datepicker = ((DatePicker) component);

		datepicker.setMaxlength(maxlength);
		datepicker.setReadonly(readonly);
		datepicker.setSize(size);
		datepicker.setInline(inline);
		datepicker.setFormat(format);
		datepicker.setPattern(pattern);
		datepicker.setOptions(options);
	}

	/**
	 * @param maxlength the maxlength to set
	 */
	public void setMaxlength(String maxlength) {
		this.maxlength = maxlength;
	}

	/**
	 * @param readonly the readonly to set
	 */
	public void setReadonly(String readonly) {
		this.readonly = readonly;
	}

	/**
	 * @param size the size to set
	 */
	public void setSize(String size) {
		this.size = size;
	}

	/**
	 * @param inline the inline to set
	 */
	public void setInline(String inline) {
		this.inline = inline;
	}

	/**
	 * @param format the format to set
	 */
	public void setFormat(String format) {
		this.format = format;
	}

	/**
	 * @param pattern the pattern to set
	 */
	public void setPattern(String pattern) {
		this.pattern = pattern;
	}

	/**
	 * @param options the options to set
	 */
	public void setOptions(String options) {
		this.options = options;
	}

}
