/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class TokenRenderer extends AbstractTemplateRenderer {

	public TokenRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

        //first input
        attrs.add("type", "hidden")
             .add("name", (String)params.get("tokenNameField"))
             .add("value", (String)params.get("name"));

        xtag("input", attrs);

        //second input
        attrs = new Attributes();
        attrs.add("type", "hidden")
             .add("name", (String)params.get("name"))
             .add("value", (String)params.get("token"));

        xtag("input", attrs);
    }
}

