/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import nuts.core.lang.Strings;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class ResetRenderer extends AbstractTemplateRenderer {

	public ResetRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

        boolean isButton = "button".equals(params.get("type"));

        attrs.add("type", "reset")
        	.id(params)
        	.name(params)
        	.cssClass(params)
        	.disabled(params)
        	.nameValue(params)
        	.tabindex(params)
        	.commons(params)
        	.events(params)
        	.dynamics(params);

        if (!isButton) {
            attrs.title(params);
        }
        
        if (isButton) {
            stag("button", attrs);
            String src = (String) params.get("src");
            String label = (String) params.get("label");
            if (Strings.isNotEmpty(src)) {
            	Attributes a = new Attributes();
            	a.add("src", src).addIfExists("alt", label);
            	xtag("img", a);
            }
            else if (Strings.isNotEmpty(label)) {
                body(label);
            }
            etag("button");
        }
        else {
            xtag("input", attrs);
        }
    }
}

