/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import nuts.core.lang.Strings;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class NutsTextAreaRenderer extends AbstractTemplateRenderer {
	public NutsTextAreaRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

		String layout = defs((String)params.get("layout"), "text");

		attrs.id(params)
			.name(params)
			.css(this, "n-" + layout + "area")
			.cols(params)
			.rows(params)
			.wrap(params)
			.disabled(params)
			.readonly(params)
			.tabindex(params)
			.maxlength(params)
			.title(params)
			.commons(params)
			.events(params)
			.dynamics(params);

		stag("textarea", attrs);
		write(formatValue());
		etag("textarea");
		
		if ("html".equals(layout)) {
			writeJsc("$(function() { $('#" 
				+ jsstr((String)params.get("id")) 
				+ "').cleditor(); });");
		}
		else if ("bbcode".equals(layout)) {
			writeJsc("$(function() { $('#"
				+ jsstr((String)params.get("id"))
				+ "').bbeditor(); });");
		}
		else {
			String maxlength = (String)params.get("maxlength");
			if (Strings.isNumeric(maxlength)) {
				writeJsc("$(function() { $('#"
					+ jsstr((String)params.get("id"))
					+ "').maxlength(); });");
			}
		}
	}
}
