/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import nuts.core.lang.Strings;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class NutsSubmitRenderer extends AbstractTemplateRenderer {

	protected String button = "submit";
	
	public NutsSubmitRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
		Attributes attrs = new Attributes();

		String type = defs((String) params.get("type"), "button");
		String icon = (String)params.get("icon");
		String sicon = (String)params.get("sicon");
		
		boolean isButton = Strings.isNotEmpty(icon) || Strings.isNotEmpty(sicon) || "button".equals(type);

		if (isButton) {
			attrs.add("type", button)
				.id(params)
				.name(params)
				.cssClass(params, "n-button n-" + button)
				.nameValue(params)
				.disabled(params)
				.tabindex(params)
				.title(params)
				.cssStyle(params)
				.commons(params)
				.events(params)
				.dynamics(params);
			stag("button", attrs);

			if (Strings.isNotEmpty(icon)) {
				write(xicon(icon + " n-button-icon"));
			}
			write("<span class=\"n-button-text\">");
		}
		else if ("image".equals(type)) {
			attrs.add("type", "image")
				.src(params)
				.addIfExists("alt", params.get("label"));
			xtag("input", attrs);
		}
		else {
			attrs.add("type", button)
				.id(params)
				.name(params)
				.cssClass(params)
				.disabled(params)
				.tabindex(params)
				.nameValue(params)
				.cssStyle(params)
				.title(params)
				.commons(params)
				.events(params)
				.dynamics(params);

			xtag("input", attrs);
		}
	}

	public static class Close extends AbstractTemplateRenderer {
		public Close(TemplateRenderingContext context) {
			super(context);
		}

		public void render() throws IOException {
			String type = defs((String) params.get("type"), "button");
			String icon = (String)params.get("icon");
			String sicon = (String)params.get("sicon");
			
			boolean isButton = Strings.isNotEmpty(icon) || Strings.isNotEmpty(sicon) || "button".equals(type);

			String body = (String) params.get("body");

			if (isButton) {
				//button body
				if (Strings.isNotEmpty(body)) {
					body(body, false);
				}
				else if (params.containsKey("label")) {
					String label = (String) params.get("label");
					if (Strings.isNotEmpty(label)) {
						body(label, false);
					}
				}

				write("</span>");
				if (Strings.isNotEmpty(sicon)) {
					write(xicon(sicon + " n-button-sicon"));
				}
				etag("button");
			}
			else {
				if (Strings.isNotEmpty(body)) {
					body(body, false);
				}
			}
		}
	}
}

