/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class NutsCheckboxRenderer extends AbstractTemplateRenderer {
	public NutsCheckboxRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

        String fieldValue = (String) params.get("fieldValue");
        String id = (String) params.get("id");
        String name = (String) params.get("name");
        Object disabled = params.get("disabled");

        String clabel = (String)params.get("clabel");
        writeIfExists("<span class=\"n-checkbox-item\">", clabel);
        attrs.add("type", "checkbox")
			.id(params)
			.name(params)
			.css(this, "n-checkbox")
			.add("value", fieldValue)
			.addIfTrue("checked", params.get("nameValue"))
			.readonly(params)
			.disabled(params)
			.tabindex(params)
			.title(params)
			.commons(params)
			.events(params)
			.dynamics(params);
        xtag("input", attrs);

        if (!Boolean.FALSE.equals(params.get("multiselectIntercept"))) {
	        //hidden input
	        attrs = new Attributes();
	        attrs.add("type", "hidden")
	                .add("id", "__checkbox_" + id)
	                .add("name", "__checkbox_" + name)
	                .add("value", fieldValue)
	                .addIfTrue("disabled", disabled);
	        xtag("input", attrs);
        }
        
        if (clabel != null) {
        	write("<label");
        	if (id != null) {
        		write(" for=\"");
        		write(html(id));
        		write("\"");
        	}
        	write(" class=\"n-checkbox-label\">");
        	body(clabel);
        	write("</label></span>");
        }
    }
}
