/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nthtml;

import nuts.core.lang.Strings;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class ButtonWrapper extends NthtmlTemplateRenderer {
	/**
	 * @param context context
	 */
	public ButtonWrapper(TemplateRenderingContext context) {
		super(context);
	}

	protected void renderHeader() throws Exception {
		String nthtml_group = (String)findInContext("nthtml_group");
		if (Strings.isEmpty(nthtml_group)) {
			write("<tr class=\"n-tr-submit\">");
			write("<td class=\"n-td-label\"></td>");
			write("<td class=\"n-td-submit\">");
		}
		write(before);
		
		if ("start".equals(group)) {
			putInContext("nthtml_group", defs((String)params.get("name"), "-"));
		}
		else if (Strings.isNotEmpty(nthtml_group)) {
			putInContext("nthtml_group", nthtml_group + "," + defs((String)params.get("name"), "-"));
		}
	}
	
	protected void renderFooter() throws Exception {
		String nthtml_group = (String)findInContext("nthtml_group");

        write(after);

		if (Strings.isEmpty(nthtml_group) || "end".equals(group)) {
			etag("td");
			etag("tr");
		}

		if ("end".equals(group)) {
			putInContext("nthtml_group", "");
		}
	}
	
	public void render() throws Exception {
		renderHeader();
		renderSimple();
		renderFooter();
	}

}
