/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java;

import java.util.Map;

import org.apache.struts2.components.template.TemplateRenderingContext;

public abstract class ThemeTemplateRenderer extends AbstractTemplateRenderer {
	private TemplateRenderer simpleRenderer;
	
	protected String before;
	protected String group;
	protected String after;
	
	/**
	 * @param context context
	 */
	public ThemeTemplateRenderer(TemplateRenderingContext context) {
		super(context);
		getThemeParams();
	}

	/**
	 * @return the simpleRenderer
	 */
	public TemplateRenderer getSimpleRenderer() {
		return simpleRenderer;
	}

	/**
	 * @param simpleRenderer the simpleRenderer to set
	 */
	public void setSimpleRenderer(TemplateRenderer simpleRenderer) {
		this.simpleRenderer = simpleRenderer;
	}

	@SuppressWarnings("unchecked")
	protected void getThemeParams() {
		before = (String)params.get("before");
		group = (String)params.get("group");
		after = (String)params.get("after");

		Map<String, Object> das = (Map<String, Object>)params.get("dynamicAttributes");
		if (das != null) {
			das.remove("before");
			das.remove("group");
			das.remove("after");
		}
	}

	protected void renderSimple() throws Exception {
		simpleRenderer.render();
	}
}
