/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.freemarker;

import nuts.core.lang.i18n.Charsets;
import nuts.exts.struts2.util.StrutsContextUtils;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.StrutsConstants;
import org.apache.struts2.views.freemarker.FreemarkerResult;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.xwork2.inject.Inject;

import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateModel;

/**
 * FreemarkerDecorateResult
 */
@SuppressWarnings("serial")
public class FreemarkerDecorateResult extends FreemarkerResult {

	private String encoding = Charsets.UTF_8;
	
	/**
	 * Constructor 
	 */
	public FreemarkerDecorateResult() {
		super();
	}

	/**
	 * Constructor
	 * @param location location
	 */
	public FreemarkerDecorateResult(String location) {
		super(location);
	}

	/**
	 * @return the encoding
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * @param encoding the encoding to set
	 */
    @Inject(value=StrutsConstants.STRUTS_I18N_ENCODING, required=false)
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	/**
	 * @see org.apache.struts2.views.freemarker.FreemarkerResult#preTemplateProcess(freemarker.template.Template, freemarker.template.TemplateModel)
	 */
	@Override
	protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
		HttpServletResponse res = StrutsContextUtils.getServletResponse();
		res.setCharacterEncoding(encoding);
		
		if (model instanceof SimpleHash) {
			SimpleHash hash = (SimpleHash)model;
			
			HttpServletRequest req = StrutsContextUtils.getServletRequest();
			
			// populate the hash with the page
			hash.put("base", req.getContextPath());
			
			Page page = (Page)req.getAttribute(RequestConstants.PAGE);
			if (page != null) {
				hash.put("page", page);
				if (page instanceof HTMLPage) {
					HTMLPage htmlPage = ((HTMLPage) page);
					hash.put("head", htmlPage.getHead());
				}
				hash.put("title", page.getTitle());
				hash.put("body", page.getBody());
				hash.put("page.properties", new SimpleHash(page.getProperties()));
			}
		}

		return super.preTemplateProcess(template, model);
	}
}
