/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.interceptor;

import nuts.core.lang.Strings;
import nuts.core.log.Log;
import nuts.core.log.Logs;
import nuts.exts.struts2.util.StrutsContextUtils;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandlerManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;

/**
 */
@SuppressWarnings("serial")
public class UnknownMethodInterceptor extends AbstractInterceptor {

	private static final Log log = Logs.getLog(UnknownMethodInterceptor.class);

	protected Container container;
	protected UnknownHandlerManager unknownHandlerManager;

	/**
	 * @param container the container to set
	 */
	@Inject
	public void setContainer(Container container) {
		this.container = container;
	}

	/**
	 * @param unknownHandlerManager the unknownHandlerManager to set
	 */
	@Inject
	public void setUnknownHandlerManager(
			UnknownHandlerManager unknownHandlerManager) {
		this.unknownHandlerManager = unknownHandlerManager;
	}

	/**
	 * Allows the Interceptor to do some processing on the request before and/or
	 * after the rest of the processing of the request by the
	 * {@link ActionInvocation} or to short-circuit the processing and just
	 * return a String return code.
	 * 
	 * @param actionInvocation the action invocation
	 * @return the return code, either returned from
	 *         {@link ActionInvocation#invoke()}, or from the interceptor
	 *         itself.
	 * @throws Exception any system-level error, as defined in
	 *             {@link com.opensymphony.xwork2.Action#execute()}.
	 */
	@SuppressWarnings("unchecked")
	public String intercept(ActionInvocation actionInvocation) throws Exception {
		Class actionClass = actionInvocation.getAction().getClass();
		String methodName = actionInvocation.getProxy().getMethod();

		@SuppressWarnings("unused")
		Method method = null;
		try {
			method = actionClass.getMethod(methodName, new Class[0]);
		}
		catch (NoSuchMethodException e) {
			// hmm -- OK, try doXxx instead
			try {
				String altMethodName = "do"
						+ Strings.capitalize(methodName);
				method = actionClass.getMethod(altMethodName, new Class[0]);
			}
			catch (NoSuchMethodException e1) {
				// well, give the unknown handler a shot
				if (unknownHandlerManager.hasUnknownHandlers()) {
					try {
						Object result = unknownHandlerManager.handleUnknownMethod(
								actionInvocation.getAction(), methodName);
						if (result instanceof Result) {
							container.inject(result);
							((Result)result).execute(actionInvocation);
							return null;
						}
						else if (result instanceof String) {
							return (String)result;
						}
					}
					catch (NoSuchMethodException e2) {
					}
				}

				String msg = "There is no Method " + methodName + " for Action " + actionClass.getName();
				if (log.isDebugEnabled()) {
					log.debug("SendError " + HttpServletResponse.SC_NOT_FOUND
							+ ":" + msg);
				}
				
				StrutsContextUtils.getServletResponse(actionInvocation).sendError(
						HttpServletResponse.SC_NOT_FOUND, msg);
				return null;
			}
		}

		return actionInvocation.invoke();
	}
}
