/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.filter;

import nuts.exts.struts2.operations.NutsPrepareOperations;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.ng.InitOperations;
import org.apache.struts2.dispatcher.ng.filter.FilterHostConfig;

/**
 * Prepares the request for execution by a later
 * {@link org.apache.struts2.dispatcher.ng.filter.StrutsExecuteFilter} filter
 * instance.
 */
public class NutsPrepareFilter implements Filter {

	protected static final String REQUEST_EXCLUDED_FROM_ACTION_MAPPING = NutsPrepareFilter.class.getName()
			+ ".REQUEST_EXCLUDED_FROM_ACTION_MAPPING";

	protected NutsPrepareOperations prepare;
	protected List<Pattern> excludedPatterns = null;

	public void init(FilterConfig filterConfig) throws ServletException {
		InitOperations init = new InitOperations();
		try {
			FilterHostConfig config = new FilterHostConfig(filterConfig);
			init.initLogging(config);
			Dispatcher dispatcher = init.initDispatcher(config);

			prepare = new NutsPrepareOperations(filterConfig.getServletContext(), dispatcher);
			excludedPatterns = init.buildExcludedPatternsList(dispatcher);

			postInit(dispatcher, filterConfig);
		}
		finally {
			init.cleanup();
		}
	}

	/**
	 * Callback for post initialization
	 */
	protected void postInit(Dispatcher dispatcher, FilterConfig filterConfig) {
	}

	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {

		HttpServletRequest request = (HttpServletRequest)req;
		HttpServletResponse response = (HttpServletResponse)res;

		try {
			prepare.setEncodingAndLocale(request, response);
			prepare.createActionContext(request, response);
			prepare.assignDispatcherToThread();
			if (excludedPatterns != null
					&& prepare.isUrlExcluded(request, excludedPatterns)) {
				request.setAttribute(REQUEST_EXCLUDED_FROM_ACTION_MAPPING,
						Boolean.TRUE);
			}
			else {
				request = prepare.wrapRequest(request);
				prepare.findActionMapping(request, response);
			}
			chain.doFilter(request, response);
		}
		finally {
			prepare.cleanupRequest(request);
		}
	}

	public void destroy() {
		prepare.cleanupDispatcher();
	}
}
