/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.dispatcher;

import nuts.core.bind.json.JsonSerializer;
import nuts.core.log.Log;
import nuts.core.log.Logs;
import nuts.exts.struts2.NutsStrutsConstants;

import java.io.PrintWriter;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;


/**
 * <!-- START SNIPPET: description -->
 *
 * A result that send the content out as plain json text.
 *
 * <!-- END SNIPPET: description -->
 *
 *
 * <!-- START SNIPPET: params -->
 *
 * <ul>
 *  <li>circleDetect (optional) = circleDetect to be used. [strict, lenient, noprop] (default: lenient)</li>
 *  <li>dateFormat (optional) = date format to be used. (default: long - Date.getTime())</li>
 *  <li>filterTypes (optional) = filter specified property types when serialize. (default: java.io.*, java.awt.*, [B, [Ljava.lang.Byte;)</li>
 *  <li>noCache (optional) = no cache to set. (default: true)</li>
 *  <li>contentType (optional) = content type to be used. (default: text/javascript)</li>
 *  <li>encoding (optional) = character encoding to be used. This character encoding will be used to set. (default: UTF-8)</li>
 *  <li>properties (default) = extra properties to be output. { "user": ... }</li>
 * </ul>
 *
 * <!-- END SNIPPET: params -->
 *
 *
 * <pre>
 * <!-- START SNIPPET: example -->
 *
 * &lt;action name="displayJsonContent" &gt;
 *   &lt;result type="json"&gt;username, password, other&lt;/result&gt;
 * &lt;/action&gt;
 *
 * &lt;action name="displayJsonContent" &gt;
 *   &lt;result type="json"&gt;
 *   	&lt;param name="properties"&gt;username, password, other&lt;/param&gt;
 *   &lt;/result&gt;
 * &lt;/action&gt;
 *
 * <!-- END SNIPPET: example -->
 * </pre>
 *
 */
@SuppressWarnings("serial")
public class JsonResult extends AbstractOMResult {

	protected static final Log log = Logs.getLog(JsonResult.class);

	/**
	 * Constructor.
	 */
	public JsonResult() {
		super();
		setContentType("text/plain");
	}

	/**
	 * @param shortName the shortName to set
	 */
    @Inject(value=NutsStrutsConstants.NUTS_JSON_SHORT_NAME, required=false)
	public void setBeanShortName(String shortName) {
		this.shortName = Boolean.parseBoolean(shortName);
	}

	/**
	 * write result
	 * @param invocation actionInvocation
	 * @param result result object
	 * @throws Exception
	 */
	@Override
	protected void writeResult(ActionInvocation invocation, Object result) throws Exception {
//		UserAgent ua = new UserAgent(StrutsContextUtils.getServletRequest(invocation));
//
//		if (ua.isMSIE()) {
//			setContentType("application/json");
//		}

		super.writeResult(invocation, result);
	}

	/**
	 * write result
	 * @param writer response writer
	 * @param result result object
	 * @throws Exception
	 */
	@Override
	protected void writeResult(PrintWriter writer, Object result) throws Exception {
		if (result != null) {
			JsonSerializer js = new JsonSerializer();
			setSerializerOptions(js);

			if (log.isDebugEnabled()) {
				if (js.isPrettyPrint()) {
					log.debug(js.serialize(result));
				}
				else {
					js.setPrettyPrint(true);
					log.debug(js.serialize(result));
					js.setPrettyPrint(false);
				}
			}
			js.serialize(result, writer);
		}
	}
}
