/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import nuts.exts.xwork2.util.ContextUtils;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;


/**
 * <!-- START SNIPPET: javadoc -->
 *
 * Write link.
 *
 * <p/>
 *
 * Configurable attributes are :-
 * <ul>
 *    <li>cdn</li>
 *    <li>debug</li>
 *    <li>version</li>
 *    <li>jquery</li>
 *    <li>jqueryUi</li>
 *    <li>jqueryPlugins</li>
 *    <li>nuts</li>
 *    <li>extjs</li>
 *    <li>extux</li>
 *    <li>nexts</li>
 *    <li>uiTheme</li>
 *    <li>exTheme</li>
 *    <li>loading</li>
 * </ul>
 *
 * <p/>
 *
 * <!-- END SNIPPET: javadoc -->
 *
 * <p/> <b>Examples</b>
 * <pre>
 *  <!-- START SNIPPET: example -->
 *  &lt;r:link /&gt;
 *  <!-- END SNIPPET: example -->
 * </pre>
 *
 */
@StrutsTag(
	name="link",
	tldBodyContent="empty",
	tldTagClass="nuts.exts.struts2.views.jsp.ui.LinkTag",
	description="Render link",
	allowDynamicAttributes = true)
public class Link extends UIBean {
	private final static String TEMPLATE = "n-link";

	// attributes
	protected String cdn;
	protected String statics;
	protected String version;
	protected String debug;
	protected String script;
	protected String style;
	protected String locale;
	protected String jquery;
	protected String jqueryUi;
	protected String jqueryPlugins;
	protected String nuts;
	protected String extjs;
	protected String extux;
	protected String nexts;
	protected String uiTheme;
	protected String exTheme;
	protected String showLoading;
	protected String closeLoading;

	/**
	 * Constructor
	 *
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public Link(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	/**
	 * Evaluate extra parameters
	 */
	protected void evaluateExtraParams() {
		super.evaluateExtraParams();

		if (locale != null) {
			addParameter("locale", findValue(locale, Locale.class));
		}
		else {
			addParameter("locale", ContextUtils.getLocale());
		}

		if (cdn != null) {
			addParameter("cdn", findValue(cdn, Boolean.class));
		}
		if (statics != null) {
			addParameter("statics", findString(statics));
		}
		if (version != null) {
			addParameter("version", findString(version));
		}
		if (debug != null) {
			addParameter("debug", findValue(debug, Boolean.class));
		}
		
		if (script != null) {
			addParameter("script", findValue(script, Boolean.class));
		}
		if (style != null) {
			addParameter("style", findValue(style, Boolean.class));
		}

		if (jquery != null) {
			addParameter("jquery", findValue(jquery, Boolean.class));
		}
		if (jqueryUi != null) {
			addParameter("jqueryUi", findValue(jqueryUi, Boolean.class));
		}
		if (jqueryPlugins != null) {
			addParameter("jqueryPlugins", findValue(jqueryPlugins, Boolean.class));
		}
		if (nuts != null) {
			addParameter("nuts", findValue(nuts, Boolean.class));
		}
		if (extjs != null) {
			addParameter("extjs", findValue(extjs, Boolean.class));
		}
		if (extux != null) {
			addParameter("extux", findValue(extux, Boolean.class));
		}
		if (nexts != null) {
			addParameter("nexts", findValue(nexts, Boolean.class));
		}
		if (uiTheme != null) {
			addParameter("uiTheme", findString(uiTheme));
		}
		if (exTheme != null) {
			addParameter("exTheme", findString(exTheme));
		}
		if (showLoading != null) {
			addParameter("showLoading", findString(showLoading));
		}
		if (closeLoading != null) {
			addParameter("closeLoading", findString(closeLoading));
		}
		
		if (Boolean.TRUE.equals(getParameter("jqueryUi"))) {
			addParameter("jquery", Boolean.TRUE);
		}
		if (Boolean.TRUE.equals(getParameter("jqueryPlugins"))) {
			addParameter("jquery", Boolean.TRUE);
		}
		if (Boolean.TRUE.equals(getParameter("nuts"))) {
			addParameter("jquery", Boolean.TRUE);
			addParameter("jqueryUi", Boolean.TRUE);
			addParameter("jqueryPlugins", Boolean.TRUE);
		}

		if (Boolean.TRUE.equals(getParameter("extux"))) {
			addParameter("extjs", Boolean.TRUE);
		}
		if (Boolean.TRUE.equals(getParameter("nexts"))) {
			addParameter("extjs", Boolean.TRUE);
			addParameter("extux", Boolean.TRUE);
		}
	}

	private Object getParameter(String name) {
		return parameters.get(name);
	}

	/**
	 * @param statics the statics to set
	 */
	@StrutsTagAttribute(description = "the property for statics")
	public void setStatics(String statics) {
		this.statics = statics;
	}

	/**
	 * @param version the version to set
	 */
	@StrutsTagAttribute(description = "the property for version")
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @param debug the debug to set
	 */
	@StrutsTagAttribute(description="The property for debug", type="Boolean", defaultValue="false")
	public void setDebug(String debug) {
		this.debug = debug;
	}

	/**
	 * @param cdn the cdn to set
	 */
	@StrutsTagAttribute(description="The property for cdn", type="Boolean", defaultValue="true")
	public void setCdn(String cdn) {
		this.cdn = cdn;
	}

	/**
	 * @param script the script to set
	 */
	@StrutsTagAttribute(description="The property for script", type="Boolean", defaultValue="true")
	public void setScript(String script) {
		this.script = script;
	}

	/**
	 * @param style the style to set
	 */
	@StrutsTagAttribute(description="The property for style", type="Boolean", defaultValue="true")
	public void setStyle(String style) {
		this.style = style;
	}
	
	/**
	 * @param locale the locale to set
	 */
	@StrutsTagAttribute(description = "the property for locale")
	public void setLocale(String locale) {
		this.locale = locale;
	}

	/**
	 * @param jquery the jquery to set
	 */
	@StrutsTagAttribute(description="The property for jquery", type="Boolean", defaultValue="false")
	public void setJquery(String jquery) {
		this.jquery = jquery;
	}

	/**
	 * @param jqueryUi the jqueryUi to set
	 */
	@StrutsTagAttribute(description="The property for jquery-ui", type="Boolean", defaultValue="false")
	public void setJqueryUi(String jqueryUi) {
		this.jqueryUi = jqueryUi;
	}

	/**
	 * @param jqueryPlugins the jqueryPlugins to set
	 */
	@StrutsTagAttribute(description="The property for jquery-plugins", type="Boolean", defaultValue="false")
	public void setJqueryPlugins(String jqueryPlugins) {
		this.jqueryPlugins = jqueryPlugins;
	}

	/**
	 * @param nuts the nuts to set
	 */
	@StrutsTagAttribute(description="The property for nuts", type="Boolean", defaultValue="false")
	public void setNuts(String nuts) {
		this.nuts = nuts;
	}

	/**
	 * @param extjs the extjs to set
	 */
	@StrutsTagAttribute(description="The property for extjs", type="Boolean", defaultValue="false")
	public void setExtjs(String extjs) {
		this.extjs = extjs;
	}

	/**
	 * @param extux the extux to set
	 */
	@StrutsTagAttribute(description="The property for extux", type="Boolean", defaultValue="false")
	public void setExtux(String extux) {
		this.extux = extux;
	}

	/**
	 * @param nexts the nexts to set
	 */
	@StrutsTagAttribute(description="The property for nexts", type="Boolean", defaultValue="false")
	public void setNexts(String nexts) {
		this.nexts = nexts;
	}

	/**
	 * @param uiTheme the uiTheme to set
	 */
	@StrutsTagAttribute(description = "the property for ui-theme")
	public void setUiTheme(String uiTheme) {
		this.uiTheme = uiTheme;
	}

	/**
	 * @param exTheme the exTheme to set
	 */
	@StrutsTagAttribute(description = "the property for ex-theme")
	public void setExTheme(String exTheme) {
		this.exTheme = exTheme;
	}

	/**
	 * @param showLoading the showLoading to set
	 */
	@StrutsTagAttribute(description = "the property for showLoading")
	public void setShowLoading(String showLoading) {
		this.showLoading = showLoading;
	}

	/**
	 * @param closeLoading the closeLoading to set
	 */
	@StrutsTagAttribute(description = "the property for closeLoading")
	public void setCloseLoading(String closeLoading) {
		this.closeLoading = closeLoading;
	}

}

