/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import nuts.exts.struts2.NutsStrutsConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc -->
 * <p/>
 * Renders HTML an input form.
 * <p/>
 * <p/>
 * The remote form allows the form to be submitted without the page being refreshed. The results
 * from the form can be inserted into any HTML element on the page.
 * <p/>
 * <p/>
 * NOTE:
 * <p/>
 * The order / logic in determining the posting url of the generated HTML form is as follows:-
 * <ol>
 * <li>
 * If the action attribute is not specified, then the current request will be used to determine the
 * posting url</li>
 * <li>
 * If the action is given, Struts will try to obtain an ActionConfig. This will be successfull if
 * the action attribute is a valid action alias defined struts.xml.</li>
 * <li>
 * If the action is given and is not an action alias defined in struts.xml, Struts will used the
 * action attribute as if it is the posting url, separting the namespace from it and using UrlHelper
 * to generate the final url.</li>
 * </ol>
 * <p/>
 * <!-- END SNIPPET: javadoc -->
 * <p/>
 * <p/>
 * <b>Examples</b>
 * <p/>
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 * &lt;p/&gt;
 * &lt;s:form ... /&gt;
 * &lt;p/&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 * 
 */
@StrutsTag(
		name = "form", 
		tldTagClass = "nuts.exts.struts2.views.jsp.ui.FormTag", 
		description = "Renders an input form", 
		allowDynamicAttributes = true)
public class Form extends org.apache.struts2.components.Form {
	private static final String OPEN_TEMPLATE = "n-form";
	private static final String TEMPLATE = "n-form-close";

	protected String loadmask;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public Form(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	/**
	 * @return open template
	 */
	public String getDefaultOpenTemplate() {
		return OPEN_TEMPLATE;
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	/**
	 * Evaluate extra parameters
	 */
	protected void evaluateExtraParams() {
		super.evaluateExtraParams();

		if (loadmask != null) {
			addParameter("loadmask", findValue(loadmask, Boolean.class));
		}
	}

	/**
	 * @param loadmask the loadmask to set
	 */
	@StrutsTagAttribute(description = "Whether the loadmask is show on submit", type = "Boolean", defaultValue = "true")
    @Inject(value=NutsStrutsConstants.NUTS_FORM_LOADMASK, required=false)
	public void setLoadmask(String loadmask) {
		this.loadmask = loadmask;
	}
}
