/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import nuts.exts.struts2.NutsStrutsConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc -->
 *
 * Creates a series of checkboxes from a list. Setup is like &lt;s:select /&gt; or &lt;s:radio /&gt;, but creates checkbox tags.
 *
 * <!-- END SNIPPET: javadoc -->
 *
 * <p/> <b>Examples</b>
 *
 * <pre>
 * <!-- START SNIPPET: example -->
 * &lt;s:checkboxlist name="foo" list="bar"/&gt;
 * <!-- END SNIPPET: example -->
 * </pre>
 *
 */
@StrutsTag(
		name="checkboxlist", 
		tldTagClass="nuts.exts.struts2.views.jsp.ui.CheckboxListTag", 
		description="Render a list of checkboxes",
		allowDynamicAttributes=true)
public class CheckboxList extends ListUIBean {
	/**
	 * TEMPLATE = "n-checkboxlist";
	 */
	public final static String TEMPLATE = "n-checkboxlist";
	
	protected Boolean multiselectIntercept;
	protected String readonly;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public CheckboxList(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}
	
	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	protected void evaluateExtraParams() {
		super.evaluateExtraParams();

		if (readonly != null) {
			addParameter("readonly", findValue(readonly, Boolean.class));
		}
		
		if (multiselectIntercept != null) {
			addParameter("multiselectIntercept", multiselectIntercept);
		}
	}

    /**
     * @param intercept intercept
     */
    @Inject(value=NutsStrutsConstants.NUTS_MULTISELECT_INTERCEPT, required=false)
    public void setMultiselectIntercept(String intercept) {
    	multiselectIntercept = Boolean.parseBoolean(intercept);
    }

    /**
     * @param readonly the readonly to set
     */
    @StrutsTagAttribute(description="Whether the input is readonly", type="Boolean", defaultValue="false")
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }
}
