/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import nuts.core.servlet.HttpServletUtils;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.exts.struts2.views.freemarker.FreemarkerUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FreemarkerAction extends CommonDataAccessAction {

	private String location;

	/**
	 * @return the location
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * @see nuts.exts.xwork2.ActionSupport#execute()
	 */
	@Override
	public String execute() throws Exception {
		HttpServletRequest request = StrutsContextUtils.getServletRequest();
		location = HttpServletUtils.getRelativeURI(request);
		if (!FreemarkerUtils.hasTemplate(location)) {
			HttpServletResponse response = StrutsContextUtils.getServletResponse();
			response.sendError(HttpServletResponse.SC_NOT_FOUND, location);
			return NONE;
		}
		return SUCCESS;
	}

}
