/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import nuts.core.io.Streams;
import nuts.core.lang.StringEscapes;
import nuts.core.lang.Strings;
import nuts.core.lang.i18n.Charsets;
import nuts.core.servlet.HttpServletSupport;
import nuts.core.util.Percent;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.exts.xwork2.util.ContextUtils;

import java.text.MessageFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class CommonWorkAction extends CommonDataAccessAction {

	protected MessageFormat onError;
	protected MessageFormat onStatus;
	protected MessageFormat onSuccess;
	private HttpServletRequest request;
	private HttpServletResponse response;

	/**
	 * @param error the error to set
	 */
	public void setError(String error) {
		this.onError = new MessageFormat(error);
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.onStatus = new MessageFormat(status);
	}

	/**
	 * @param success the success to set
	 */
	public void setSuccess(String success) {
		this.onSuccess = new MessageFormat(success);
	}

	/**
	 * @return the actionPrefix
	 */
	public String getActionPrefix() {
		return Strings.substringBefore(ContextUtils.getActionName(), "_");
	}

	public String stop() {
		return NONE;
	}
	
	public String status() {
		return NONE;
	}
	
	public String execute() {
		return NONE;
	}

	protected void init() throws Exception {
		response = StrutsContextUtils.getServletResponse();
		HttpServletSupport hsrs = new HttpServletSupport(request, response);
		hsrs.setNoCache(true);
		hsrs.setCharset(Charsets.UTF_8);
		hsrs.setContentType("text/html");
		hsrs.writeResponseHeader();
	}
	
	protected void printStatus(int progress, String msg) {
		if (onStatus == null) {
			printMessage(progress + ": " + msg + Streams.LINE_SEPARATOR);
		}
		else {
			printScript(onStatus.format(new Object[] { String.valueOf(progress), StringEscapes.escapeJavaScript(msg) }));
		}
	}
	
	protected void printError(String msg) {
		if (onError == null) {
			printMessage(msg + Streams.LINE_SEPARATOR);
		}
		else {
			printScript(onError.format(new Object[] { StringEscapes.escapeJavaScript(msg) }));
		}
	}
	
	protected void printSuccess(String msg) {
		if (onSuccess == null) {
			printMessage(msg + Streams.LINE_SEPARATOR);
		}
		else {
			printScript(onSuccess.format(new Object[] { StringEscapes.escapeJavaScript(msg) }));
		}
	}
	
	protected void printMessage(String msg) {
		try {
			response.getWriter().write(msg);
			response.getWriter().flush();
		}
		catch (Exception e) {
		}
	}

	protected void printScript(String script) {
		String s = "<script>" + script + "</script>"; 
		printMessage(s);
	}

	protected class ProgressBar extends Percent {
//		private int savePercent = -1;
		private String msg;

		/**
		 * constructor
		 */
		public ProgressBar() {
		}

		/**
		 * @param msg the msg to set
		 */
		public void setMsg(String msg) {
			this.msg = msg;
		}

		/**
		 * @param value value
		 */
		@Override
		public void setValue(long value) {
			super.setValue(value);

			int percent = getPercent();
			printStatus(percent, msg);
//			if (savePercent != percent) {
//				savePercent = percent;
//				printProcess(percent, msg);
//			}
		}
	}
}
