/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import nuts.exts.xwork2.ActionSupport;
import nuts.exts.xwork2.util.ContextUtils;

import java.util.Map;

import org.apache.struts2.interceptor.ApplicationAware;
import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.RequestAware;
import org.apache.struts2.interceptor.SessionAware;

/**
 * CommonAction
 */
public class CommonAction extends ActionSupport implements CacheAware, ApplicationAware, SessionAware,
		RequestAware, ParameterAware, ActionConstsAware, ActionUtilsAware {

	/*------------------------------------------------------------
	 * aware implements
	 *------------------------------------------------------------*/
	private Map<String, Object> cache;
	private Map<String, Object> application;
	private Map<String, Object> session;
	private Map<String, Object> request;
	private Map<String, String[]> parameters;

	private ActionUtilities utils;
	private ActionConstants consts;

	/**
	 * @return the cache
	 */
	public Map<String, Object> getCache() {
		return cache;
	}

	/**
	 * @param cache the cache to set
	 */
	public void setCache(Map<String, Object> cache) {
		this.cache = cache;
	}

	/**
	 * @return the application
	 */
	protected Map<String, Object> getApplication() {
		if (application == null) {
			application = ContextUtils.getApplication();
		}
		return application;
	}

	/**
	 * @param application the application to set
	 */
	public void setApplication(Map<String, Object> application) {
		System.out.println(application.getClass());
		this.application = application;
	}

	/**
	 * @return the session
	 */
	protected Map<String, Object> getSession() {
		if (session == null) {
			session = ContextUtils.getSession();
		}
		return session;
	}

	/**
	 * @param session the session to set
	 */
	public void setSession(Map<String, Object> session) {
		this.session = session;
	}

	/**
	 * @return the request
	 */
	protected Map<String, Object> getRequest() {
		if (request == null) {
			request = ContextUtils.getRequest();
		}
		return request;
	}

	/**
	 * @param request the request to set
	 */
	public void setRequest(Map<String, Object> request) {
		this.request = request;
	}

	/**
	 * @return the parameters
	 */
	@SuppressWarnings("unchecked")
	protected Map<String, String[]> getParameters() {
		if (parameters == null) {
			Map map = ContextUtils.getParameters();
			parameters = (Map<String, String[]>)map;
		}
		return parameters;
	}

	/**
	 * @param parameters the parameters to set
	 */
	public void setParameters(Map<String, String[]> parameters) {
		this.parameters = parameters;
	}

	/**
	 * @return the utils
	 */
	public ActionUtilities getUtils() {
		return utils;
	}

	/**
	 * @param utils the utils to set
	 */
	public void setUtils(ActionUtilities utils) {
		this.utils = utils;
	}

	/**
	 * @return the consts
	 */
	public ActionConstants getConsts() {
		return consts;
	}

	/**
	 * @param consts the consts to set
	 */
	public void setConsts(ActionConstants consts) {
		this.consts = consts;
	}

}
