/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.util.Map;

/**
 * Actions that want to be aware of the cache Map object should implement this interface.
 * This will give them access to a Map where they can put objects that should be available
 * to other parts of the cache. <p>
 * <p/>
 * Typical uses are configuration objects and caches.
 *
 */
public interface CacheAware {

    /**
     * Sets the map of cache properties in the implementing class.
     *
     * @param cache a Map of cache properties.
     */
    public void setCache(Map<String,Object> cache);
}
