/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import nuts.core.dao.DaoSession;
import nuts.core.log.Log;
import nuts.core.log.Logs;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.exts.xwork2.util.ContextUtils;

import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;



/**
 */
public class ActionHelper {

	protected static Log log = Logs.getLog(ActionHelper.class);

	protected CommonAction action;
	
	/**
	 * Constructor
	 */
	public ActionHelper(CommonAction action) {
		this.action = action;
	}

	/**
	 * @return action
	 */
	public CommonAction getAction() {
		return action;
	}
	
	/**
	 * @return request
	 */
	public Map<String, Object> getRequest() {
		return action.getRequest();
	}
	
	/**
	 * @return session
	 */
	public Map<String, Object> getSession() {
		return action.getSession();
	}
	
	/**
	 * @return application
	 */
	public Map<String, Object> getApplication() {
		return action.getApplication();
	}
	
	/**
	 * @return locale
	 */
	public Locale getLocale() {
		return action.getLocale();
	}
	
	/**
	 * @return namespace
	 */
	public String getNamespace() {
		return ContextUtils.getNamespace();
	}

	/**
	 * get action name
	 * @return action name
	 */
	public String getActionName() {
		return ContextUtils.getActionName();
	}

	/**
	 * get action method
	 * @return action method
	 */
	public String getActionMethod() {
		return ContextUtils.getActionMethod();
	}

	/**
	 * Gets the HTTP servlet request object.
	 *
	 * @return the HTTP servlet request object.
	 */
	public HttpServletRequest getServletRequest() {
		return StrutsContextUtils.getServletRequest();
	}

	/**
	 * Gets the HTTP servlet response object.
	 *
	 * @return the HTTP servlet response object.
	 */
	public HttpServletResponse getServletResponse() {
		return StrutsContextUtils.getServletResponse();
	}

	/**
	 * Gets the servlet context.
	 *
	 * @return the servlet context.
	 */
	public ServletContext getServletContext() {
		return StrutsContextUtils.getServletContext();
	}

	/**
	 * @return dataAccessSession
	 */
	public DaoSession getDataAccessSession() {
		if (action instanceof CommonDataAccessAction) {
			return ((CommonDataAccessAction)action).getDataAccessSession();
		}
		return null;
	}

	/**
	 * @return the utils
	 */
	public ActionUtilities getUtils() {
		return action.getUtils();
	}

	/**
	 * @return the consts
	 */
	public ActionConstants getConsts() {
		return action.getConsts();
	}
}
