/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.mybatis;

import nuts.core.dao.DataHandler;

import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

/**
 */
public class MyBatisResultHandler implements ResultHandler {
	private DataHandler dataHandler;
	private int count = 0;
	
	
	/**
	 * @param dataHandler data handler
	 */
	public MyBatisResultHandler(DataHandler dataHandler) {
		this.dataHandler = dataHandler;
	}

	/**
	 * @return the count
	 */
	public int getCount() {
		return count;
	}

	@SuppressWarnings("unchecked")
	public void handleResult(ResultContext context) {
		Object data = context.getResultObject();
		try {
			if (dataHandler.handleData(data)) {
				count++;
			}
			else {
				context.stop();
			}
		}
		catch (Exception e) {
			throw new RuntimeException("Data Handle Error: " + data, e);
		}
	}
} 
