/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.ibatis.type;

import nuts.core.bind.json.Jsons;
import nuts.core.lang.Strings;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;

/**
 * base collection implementation of TypeHandler
 */
public abstract class CollectionTypeHandler extends BaseTypeHandler {
	private Class<?> colClass;
	
	protected CollectionTypeHandler(Class<?> colClass) {
		this.colClass = colClass;
	}
	
	protected String toString(Object v) throws SQLException {
		try {
			return Jsons.toJson(v);
		}
		catch (Exception e) {
			throw new SQLException(e);
		}
	}

	protected Object toCollection(String v) throws SQLException {
		try {
			if (Strings.isEmpty(v)) {
				return colClass.newInstance();
			}
			else {
				return Jsons.fromJson(v, colClass);
			}
		}
		catch (Exception e) {
			throw new SQLException(e);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#setParameter(java.sql.PreparedStatement, int, java.lang.Object, java.lang.String)
	 */
	public void setParameter(PreparedStatement ps, int i, Object parameter,
			String jdbcType) throws SQLException {
		String val = null;
		if (parameter != null) {
			val = toString(parameter);
		}
		ps.setString(i, val);
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#getResult(java.sql.ResultSet, java.lang.String)
	 */
	public Object getResult(ResultSet rs, String columnName)
			throws SQLException {
		String s = rs.getString(columnName);
		if (rs.wasNull()) {
			return null;
		}
		else {
			return toCollection(s);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#getResult(java.sql.ResultSet, int)
	 */
	public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
		String s = rs.getString(columnIndex);
		if (rs.wasNull()) {
			return null;
		}
		else {
			return toCollection(s);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#getResult(java.sql.CallableStatement, int)
	 */
	public Object getResult(CallableStatement cs, int columnIndex)
			throws SQLException {
		String s = cs.getString(columnIndex);
		if (cs.wasNull()) {
			return null;
		}
		else {
			return toCollection(s);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#valueOf(java.lang.String)
	 */
	public Object valueOf(String s) {
		return s;
	}

}
