if (typeof String.prototype.trimLeft != "function") {
	String.prototype.trimLeft = function() {
		var re = /^\s+/;
		return this.replace(re, "");
	};
}
if (typeof String.prototype.trimRight != "function") {
	String.prototype.trimRight = function() {
		var re = /\s+$/;
		return this.replace(re, "");
	};
}
if (typeof String.prototype.trim != "function") {
	String.prototype.trim = function() {
		var re = /^\s+|\s+$/g;
		return this.replace(re, "");
	};
}
if (typeof String.prototype.stripLeft != "function") {
	String.prototype.stripLeft = function() {
		var re = /^[\s\u3000]+/;
		return this.replace(re, "");
	};
}
if (typeof String.prototype.stripRight != "function") {
	String.prototype.stripRight = function() {
		var re = /[\s\u3000]+$/;
		return this.replace(re, "");
	};
}
if (typeof String.prototype.strip != "function") {
	String.prototype.strip = function() {
		var re = /^[\s\u3000]+|[\s\u3000]+$/g;
		return this.replace(re, "");
	};
}
if (typeof String.prototype.left != "function") {
	String.prototype.left = function(len) {
		return this.substr(0, len);
	};
}
if (typeof String.prototype.mid != "function") {
	String.prototype.mid = String.prototype.substr;
}
if (typeof String.prototype.right != "function") {
	String.prototype.right = function(len) {
		if (len >= this.length) {
			return this;
		}
		return this.substr(this.length - len, len);
	};
}
if (typeof String.prototype.leftPad != "function") {
	String.prototype.leftPad = function(ch, size) {
		if (!ch) {
			ch = " ";
		}
		var r = this;
		while (r.length < size) {
			r = ch + r;
		}
		return r;
	};
}
if (typeof String.prototype.rightPad != "function") {
	String.prototype.rightPad = function(ch, size) {
		if (!ch) {
			ch = " ";
		}
		var r = this;
		while (r.length < size) {
			r += chr;
		}
		return r;
	};
}
if (typeof String.prototype.startsWith != "function") {
	String.prototype.startsWith = function(prefix, toffset) {
		return this.indexOf(prefix) == (toffset || 0);
	};
}
if (typeof String.prototype.endsWith != "function") {
	String.prototype.endsWith = function(suffix) {
		return this.startsWith(suffix, this.length - suffix.length);
	};
}
if (typeof String.prototype.capitalize != "function") {
	String.prototype.capitalize = function() {
		return this.substr(0, 1).toUpperCase() + this.substr(1);
	};
}
if (typeof String.prototype.uncapitalize != "function") {
	String.prototype.uncapitalize = function() {
		return this.substr(0, 1).toLowerCase() + this.substr(1);
	};
}
if (typeof String.prototype.format != "function") {
	String.prototype.format = function() {
		var args = arguments;
		return this.replace(/\{(\d+)\}/g, function(m, i) {
			return args[i];
		});
	};
}
if (typeof String.prototype.size != 'function') {
	String.prototype.size = function(s) {
		var sz = 0;
		for (var i = 0; i < this.length; i++) {
			sz++;
			if (this.charCodeAt(i) > 0xFF) {
				sz++;
			}
		}
		return sz;
	};
}

var fso = new ActiveXObject("Scripting.FileSystemObject");

var args = WScript.Arguments;
if (args.length < 1) {
	WScript.Echo("ui-css.js <jquery-ui.css> [n.css]");
	WScript.Quit();
}

var cssui = args(0);
var csstb = cssui;

if (args.length > 1) {
	csstb = args(1);
}
WScript.Echo(cssui + " -> " + csstb);

var fui = fso.OpenTextFile(cssui);
var aui = [];
while (!fui.AtEndOfStream) {
	aui[aui.length] = fui.ReadLine();
}
fui.Close();

var mtb = [
   	{
		"id": ".ui-widget-header a",
		"name": ".ui-widget-header a, .ui-widget-header a:link, .ui-widget-header a:visited",
		"includes": [ "color" ]
	}, {
    	"id": ".ui-widget-content a",
    	"name": ".ui-widget-content a, .ui-widget-content a:link, .ui-widget-content a:visited",
		"includes": [ "color" ]
	}, {
		"id": ".ui-state-active a, .ui-state-active a:link, .ui-state-active a:visited",
		"name": ".ui-state-active>a, .ui-state-active>a:link, .ui-state-active>a:visited, a.ui-state-active, a:link.ui-state-active, a:visited.ui-state-active",
		"includes": [ "color" ]
	}, {
		"id": ".ui-state-highlight a, .ui-widget-content .ui-state-highlight a,.ui-widget-header .ui-state-highlight a",
    	"name": ".ui-state-highlight>a, .ui-state-highlight>a:link, .ui-state-highlight>a:visited, a.ui-state-highlight",
		"includes": [ "color" ]
	}, {
		"id": ".ui-widget-header",
		"name": ".n-table-toolbar",
		"includes": [ "border", "background", "color" ]
	}, {
		"id": ".ui-widget-header",
		"name": ".n-table-wrapper",
		"includes": [ "border" ],
		"css": {
  			"background": "#FFFFFF"
  		}
	}, {
		"name": ".n-table-wrapper .n-table",
		"style": {
			"margin": "-1px 0 0 -1px"
		}
	}, {
		"id": ".ui-widget-header",
		"name": ".n-table",
		"includes": [ "border" ],
		"css": { 
		 	"border-collapse": "collapse",
		 	"font-size": "1em" 
		}
	}, {
		"id": ".ui-widget-header",
		"name": ".n-table thead",
		"includes": [ "background" ],
		"css": { 
		 	"font-size": "1em" 
		}
	}, {
		"id": ".ui-widget-header",
		"name": ".n-table thead th",
		"includes": [ "border", "color" ],
		"css": { 
			"font-weight": "normal",
			"padding": "4px",
			"text-align": "left",
			"vertical-align": "middle",
			"white-space": "nowrap"
		}
	}, {
		"name": ".n-table thead th.n-sortable, .n-table thead th.n-sorted",
		"css": { 
			"cursor": "pointer"
		}
	}, {
		"id": ".ui-state-hover, .ui-widget-content .ui-state-hover, .ui-widget-header .ui-state-hover, .ui-state-focus, .ui-widget-content .ui-state-focus, .ui-widget-header .ui-state-focus",
		"name": ".n-table thead th.n-sortable:hover, .n-table thead th.n-sorted",
		"includes": [ "background", "border", "color" ],
		"css": { 
			"font-weight": "normal"
		}
	}, {
		"id": ".ui-icon",
		"name": ".n-table thead th.n-sortable .ui-icon",
		"includes": [ "background-image" ]
	}, {
		"id": ".ui-state-default .ui-icon",
		"name": ".n-table thead th.n-sorted .ui-icon",
		"includes": [ "background-image" ]
	}, {
		"name": ".n-table thead th.ui-state-hover",
		"style": { 
			"font-weight": "normal"
		}
	}, {
		"name": ".n-table tbody",
		"style": { 
		 	"font-size": "0.9em" 
		}
	}, {
//		"id": ".ui-widget input, .ui-widget select, .ui-widget textarea, .ui-widget button",
		"name": ".n-table tbody input, .n-table tbody select, .n-table tbody textarea, .n-table tbody button",
		"style": {
			"font-size": "1.1em"
		}
	}, {
//		"id": ".ui-widget-header a",
//		"name": ".n-table thead a",
//		"includes": [ "color" ]
//	}, {
//		"name": ".n-table thead a, .n-table thead a:hover",
//		"style": { 
//			"font-weight": "normal",
//			"text-decoration": "none" 
//		}
//	}, {
//		"id": ".ui-widget-content",
//		"name": ".n-table tbody tr",
//		"includes": [ "background", "color" ]
//	}, {
		"name": ".n-table tr.n-tr-odd",
		"style": {
			"background": "#FFFFFF"
		}
	}, {
		"name": ".n-table tr.n-tr-even",
		"style": {
			"background": "#F6F7F8"
		}
	}, {
		"id": ".ui-state-hover, .ui-widget-content .ui-state-hover, .ui-widget-header .ui-state-hover, .ui-state-focus, .ui-widget-content .ui-state-focus, .ui-widget-header .ui-state-focus",
		"name": ".n-table tbody tr:hover, .n-table tbody tr.n-tr-odd:hover, .n-table tbody tr.n-tr-even:hover",
		"includes": [ "background", "color", "font-style" ],
		"css": {
			"font-weight": "normal"//,"font-style": "italic"
		}
/*	}, {
		"name": ".n-table tbody tr:hover th, .n-table tbody tr:hover td",
		"style": { 
			"font-weight": "normal",
			"font-style": "italic"
		}*/
	}, {
		"id": ".ui-state-default, .ui-widget-content .ui-state-default, .ui-widget-header .ui-state-default",
		"name": ".n-table tbody th",
		"includes": [ "border" ],
		"css": {
			"font-weight": "normal",
			"padding": "2px 4px",
			"vertical-align": "middle"
		}
	}, {
		"id": ".ui-widget-content",
		"name": ".n-table tbody td",
		"includes": [ "border" ],
		"css": { 
//			"border-left": "*border",
//			"border-top": "*border",
//			"border-bottom": "*border",
			"font-weight": "normal",
			"padding": "2px 4px",
			"vertical-align": "middle"
		}
	}, {
		"id": ".ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight",
		"name": ".n-table tbody tr.n-selected",
		"includes": [ "background" ]
	}, {
		"id": ".ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight",
		"name": ".n-table tbody tr.n-selected td",
		"includes": [ "border", "color" ]
// 	}, {
//		"id": ".ui-widget-content a",
//		"name": ".n-table tbody a"
//	}, {
//		"id": ".ui-state-hover a, .ui-state-hover a:hover",
//		"name": ".n-table tbody tr:hover a",
//		"excludes": [ "text-decoration" ]
//	}, {
//		"id": ".ui-state-hover a, .ui-state-hover a:hover",
//		"name": ".n-table tbody tr.ui-state-hover a",
//		"excludes": [ "text-decoration" ]
//	}, {
//		"id": ".ui-state-highlight a, .ui-widget-content .ui-state-highlight a,.ui-widget-header .ui-state-highlight a",
//		"name": ".n-table tbody tr.ui-state-highlight a",
//		"excludes": [ "text-decoration" ]
	}, {
		"id": ".ui-state-default, .ui-widget-content .ui-state-default, .ui-widget-header .ui-state-default",
		"name": ".n-button",
		"includes": [ "border", "background", "color" ]
	}, {
		"id": ".ui-corner-all, .ui-corner-top, .ui-corner-left, .ui-corner-tl",
		"name": ".n-button",
		"css": { 
			"-moz-border-radius": "*border-top-left-radius",
			"-webkit-border-radius": "*border-top-left-radius",
			"-khtml-border-radius": "*border-top-left-radius",
			"border-radius": "*border-top-left-radius"
		}
	}, {
		"id": ".ui-state-hover, .ui-widget-content .ui-state-hover, .ui-widget-header .ui-state-hover, .ui-state-focus, .ui-widget-content .ui-state-focus, .ui-widget-header .ui-state-focus",
		"name": ".n-button:hover",
		"includes": [ "border", "background", "color" ]
	}
];

function parseStyle(str) {
	str = str.trim();
	if (str.startsWith("{")) {
		str = str.substr(1);
	}
	if (str.endsWith("}")) {
		str = str.substr(0, str.length - 1);
	}
	var css = {};
	var sa = str.split(";");
	for (var i = 0; i < sa.length; i++) {
		var s = sa[i].trim();
		var d = s.indexOf(":");
		if (d > 0) {
			css[s.substring(0, d).trim()] = s.substring(d + 1).trim();
		}
	}
	return css;
}

var ftb = fso.CreateTextFile(csstb, true);
for (var i = 0; i < aui.length; i++) {
	var line = aui[i];
	ftb.WriteLine(line);
	
	for (var j = 0; j < mtb.length; j++) {
		var v = mtb[j];
		if (!v.style && v.id) {
			if (line.indexOf(v.id) == 0) {
				var l2 = line.substring(v.id.length).trim();
				if (l2.charAt(0) == '{') {
					v.style = parseStyle(l2);
					if (v.css) {
						if (typeof(v.includes) == 'undefined') {
							v.includes = [];
						}
						for (n in v.css) {
							v.includes.push(n);
							
							var vv = v.css[n];
							if (vv.startsWith("*")) {
								vv = vv.substr(1);
								vv = v.style[vv];
							}
							v.style[n] = vv;
						}
					}
				}
			}
		}
	}
}

ftb.WriteLine("");
ftb.WriteLine("");
ftb.WriteLine("/* Table");
ftb.WriteLine("----------------------------------*/");
for (var j = 0; j < mtb.length; j++) {
	var v = mtb[j];
	if (v.style) {
		ftb.Write(v.name + " { ");
		for (var k in v.style) {
			var s = v.style[k];
			if (s != null && s != "") {
				var w = true;
				if (v.excludes) {
					for (var i = 0; i < v.excludes.length; i++) {
						if (v.excludes[i] == k) {
							w = false;
							break;
						}
					}
				}

				if (w && v.includes) {
					w = false;
					for (var i = 0; i < v.includes.length; i++) {
						if (v.includes[i] == k) {
							w = true;
							break;
						}
					}
				}

				if (w) {
					ftb.Write(k + ": " + s + "; ");
				}
			}
		}
		ftb.WriteLine("}");
	}
}
