<#--
/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>

<div class="n-section" id="a_ognleval">
	<div class="n-section-head">
		<em class="n-section-icon n-icon n-icon-calculator"></em>
		<h3 class="n-section-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-section-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<@n.form id="ognleval" method="get" theme="simple" onsubmit="return ognlEvaluate();">
		<table width="100%">
			<tr><td>Expression: (Ctrl+Enter to evaluate)</td></tr>
			<tr><td><@n.textarea name="expr" rows="8" cssStyle="width:100%"/></td></tr>
			<tr><td align="center"><@n.submit id="ognleval_submit" cssClass="submit" icon="n-icon-bullet_go">Evaluate</@n.submit></td></tr>
		</table>
		</@n.form>
		
		<div class="hr"></div>

		<pre id="ognleval_result"></pre>
	</div>
	<script type="text/javascript">
		$(function() {
			$('#ognleval_expr').focus().keyup(function(evt) {
				if (evt.ctrlKey && evt.which == 13) {
					$('#ognleval_submit').click();
				}
			});
		});
		function ognlEvaluate() {
			try {
				$('#ognleval').loadmask("Evaluating...");
				$.ajax({
					url: $('#ognleval').attr('action'),
					data: $('#ognleval').serializeArray(),
					dataType: 'text',
					success: function(data, ts, xhr) {
						$('#ognleval').unloadmask();
						$('#ognleval_result').html(data.formatXml().escapeHtml());
					},
					error: function(xhr, ts, ex) {
						$('#ognleval').unloadmask();
						$('#ognleval_result').html((ex + '\r\n' + xhr.responseText).escapeHtml());
					}
				});
			}
			catch (ex) {
				$('#ognleval_result').html(("ERROR:\r\n" + e).escapeHtml());
			}
			return false;
		}
	</script>
</div>

</body>
</html>
