<#--
/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
	<style type="text/css">
		.di-d {
			overflow: auto;
		}
		.di-t {
			width: 100%;
		}
	</style>
</head>

<body>

<div class="n-section" id="a_dataimp">
	<div class="n-section-head">
		<em class="n-section-icon n-icon n-icon-database_gear"></em>
		<h3 class="n-section-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-section-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<@n.form id="dataimp" method="post" enctype="multipart/form-data" theme="nxhtml">
			<@n.select key="target" list="targetSet"/>
			<@n.file
				name="uploadFile"
				value=""
				size="50"
				label="%{getText('uploadFile')}"
				tooltip="%{getText('uploadFile-tip', '')}"
				onchange="onFileChange(this)"
			/>
			<@n.checkbox name="deleteAll" clabel="${action.getText('deleteAll')}" fieldValue="true"/>
			<@n.checkbox name="propertyHeader" clabel="${action.getText('propertyHeader')}" fieldValue="true"/>
			<@n.submit icon="n-icon-database_save"><@n.text name="button-import"/></@n.submit>
		</@n.form>
		
		<script type="text/javascript">
			function onFileChange(e) {
				var fn = $(e).val().toUpperCase();
				var st = $('#dataimp_target').get(0);
				for (var i = 0; i < st.options.length; i++) {
					if (fn.indexOf(st.options[i].text) >= 0) {
						st.selectedIndex = i;
						break;
					}
				}
			}
		</script>

<#if uploadDataList?has_content>
		<br/>
		<div class="hr"></div>
		<br/>
	<#list uploadDataList as uploadData>
		&lt;&lt;${uploadData[0]}&gt;&gt; (${uploadData?size - 3})
		<div class="n-table-wrapper di-d">
		<table class="n-table di-t">
			<#list uploadData as row>
				<#if row_index == 0>
				<#elseif row_index < 3>
					<#if row_index == 1><thead></#if>
					<tr><th>##</th><#list row as c><th>${(c!)?html}</th></#list></tr>
					<#if row_index == 2></thead></#if>
				<#else>
					<#if row_index == 3><tbody></#if>
					<tr><th>${row_index - 2}</th><#list row as c><td>${(c!)?html}</td></#list></tr>
					<#if !row_has_next></tbody></#if>
				</#if>
			</#list>
		</table>
		</div>
		<br/><br/>
	</#list>
</#if>
	</div>
	<script type="text/javascript">
		$(function() {
			$('.di-d').autosize();
		});
	</script>
</div>

</body>
</html>
