<#--
/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
	<style type="text/css">
		.cron-tb {
			width: 100%;
		}
		.cron-tb th {
			font-weight: normal;
			vertical-align: top;
		}
		.cron-tb td {
			vertical-align: top;
		}
		.cron-th-no {
			width: 20px;
		}
		.cron-th-url, .cron-th-desc, .cron-th-sche, .cron-th-result {
			padding: 0 3px;
			width: 100px;
			white-space: nowrap;
		}
		.cron-td-url, .cron-td-desc, .cron-td-sche, .cron-td-result {
			width: 99%;
		}
		.cron-td-result {
			color: #008;
		}
		.cron-exec, .cron-start, .cron-stop, .cron-time {
			margin-left: 20px;
		}
	</style>
</head>

<body>

<div class="n-section" id="a_sqlexec">
	<div class="n-section-head">
		<ul class="n-toolbar">
			<li><@n.a icon="n-icon-clock_play" href="#" onclick="return cronJobStartAll();"><@n.text name='button-start-all'/></@n.a></li>
			<li><@n.a icon="n-icon-clock_stop" href="#" onclick="return cronJobStopAll();"><@n.text name='button-stop-all'/></@n.a></li>
		</ul>
		<em class="n-section-icon n-icon n-icon-clock"></em>
		<h3 class="n-section-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-section-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<#if cronEntries??>
		<#list cronEntries as ce>
		<div class="cron-div">
		<table class="cron-tb">
			<tr><th class="cron-th-no" rowspan="4">${ce_index + 1}.</th>
				<th class="cron-th-url"><@n.text name="label-url"/>:</th>
				<td class="cron-td-url">${base}${(ce.getUrl()!'')?html}</td>
			</tr>
			<tr><th class="cron-th-desc"><@n.text name="label-description"/>:</th>
				<td class="cron-td-desc">${(ce.description!'')?html}</td>
			</tr>
			<tr><th class="cron-th-sche"><@n.text name="label-schedule"/>:</th>
				<td class="cron-td-sche">${(ce.schedule!'')?html}
					<@n.a cssClass="cron-exec" icon="n-icon-cog_go" href="#" onclick="return cronJobExec(this);"><@n.text name="button-exec"/></@n.a>
					<@n.a cssClass="cron-start" icon="n-icon-clock_play" href="#" onclick="return cronJobStart(this);"><@n.text name="button-start"/></@n.a>
					<@n.a cssClass="cron-stop" icon="n-icon-clock_stop" href="#" onclick="return cronJobStop(this);" style="display: none"><@n.text name="button-stop"/></@n.a>
					<span class="cron-time"></span>
				</td>
			</tr>
			<tr><th class="cron-th-result"><@n.text name="label-result"/>:</th>
				<td class="cron-td-result"></td>
			</tr>
		</table>
		</div>
		<div class="hr"></div>
		</#list></#if>
	</div>
	<script type="text/javascript">
		function cronJobExec(el) {
			var $d = $(el).closest('div.cron-div');
			var $a = $d.find('.cron-td-url');
			var $r = $d.find('.cron-td-result');

			try {
				$d.loadmask();
				$r.html((new Date()).format('yyyy-MM-dd HH:mm:ss'));

				$.ajax({
					url: $a.text(),
					dataType: 'text',
					success: function(data, ts, xhr) {
						$d.unloadmask();
						$r.html($r.html() 
							+ '<pre>' + data.formatXml().escapeHtml() + '</pre>');
					},
					error: function(xhr, ts, ex) {
						$d.unloadmask();
						$r.html($r.html()
							+ '<pre>'
							+ ((ex ? (ex + '\r\n') : '') + xhr.responseText).formatXml().escapeHtml()
							+ '</pre>');
					}
				});
			}
			catch (ex) {
				$r.html((new Date()).format('yyyy-MM-dd HH:mm:ss') 
					+ '<pre>' + ('ERROR:\r\n' + ex).escapeHtml() + '</pre>');
			}
			return false;
		}

		function formatTime(t) {
			var h = '00';
			var m = '00';
			var s = '00';
			
			if (t >= 3600) {
				h = String.leftPad(Math.floor(t / 3600), '0', 2);
				t = t - 3600 * h;
			}
			if (t > 60) {
				m = String.leftPad(Math.floor(t / 60), '0', 2);
				t = t - 60 * m;
			}
			if (t > 0) {
				s = String.leftPad(t, '0', 2);
			}
			return h + ':' + m + ':' + s;
		}
		
		var cronJobs = {};

		function cronJobStart(el) {
			var $a = $(el).hide();
			var $d = $a.closest('div.cron-div');
			var $r = $d.find('.cron-td-result');

			try {
				var jid = parseInt($d.find('.cron-th-no').text());
	
				var sit = $d.find('.cron-td-sche').text();

				var it = parseInt(sit.replace('every', '').trim());
				if (sit.indexOf('days') > 0) {
					it = it * 24 * 60 * 60;
				}
				else if (sit.indexOf('hours') > 0) {
					it = it * 60 * 60;
				}
				else if (sit.indexOf('minutes') > 0) {
					it = it * 60;
				}
				else if (sit.indexOf('seconds') > 0) {
				}
				else {
					throw ('Incorrect cron job schedule (' + jid + '): ' + sit);
				}

				var st = it;
				cronJobs[jid] = setInterval(function() {
						st -= 1;
						if (st <= 0) {
							st = it;
							cronJobExec($d.find('.cron-exec'));
						}
						else {
							$a.nextAll('.cron-time').html(formatTime(st));
						}
					}, 1000);
				$a.nextAll('.cron-stop').show();
			}
			catch (ex) {
				$r.html((new Date()).format('yyyy-MM-dd HH:mm:ss') 
					+ '<pre>' + ('ERROR:\r\n' + ex).escapeHtml() + '</pre>');
			}
			
			return false;
		}
		
		function cronJobStop(el) {
			var $a = $(el).hide();
			var $d = $a.closest('div.cron-div');
			var $r = $d.find('.cron-td-result');

			try {
				var jid = parseInt($d.find('.cron-th-no').text());
				var tid = cronJobs[jid];
				if (tid) {
					clearInterval(tid);
					delete cronJobs[jid];
				}
				$a.prevAll('.cron-start').show();
				$a.nextAll('.cron-time').empty();
			}
			catch (ex) {
				$r.html((new Date()).format('yyyy-MM-dd HH:mm:ss') 
					+ '<pre>' + ('ERROR:\r\n' + ex).escapeHtml() + '</pre>');
			}
			return false;
		}
		
		function cronJobStartAll() {
			$('.cron-div .cron-start').each(function() {
				if (!$(this).is(':hidden')) {
					cronJobStart(this);
				}
			});
		}
		
		function cronJobStopAll() {
			$('.cron-div .cron-stop').each(function() {
				if (!$(this).is(':hidden')) {
					cronJobStop(this);
				}
			});
		}
	</script>
</div>

</body>
</html>
