Ext.ns('Nexts.plugins');
 
/**
 * @class Nexts.plugins.FieldAutoExpand
 * @extends Ext.util.Observable
 *
 * Creates new FieldAutoExpand plugin
 * @constructor
 * @param {Object} config The config object
 */
Nexts.plugins.FieldAutoExpand = function(config) {
	Ext.apply(this, config);

	this.addEvents(
		/**
		 * @event autoexpand
		 * Fires after auto expanding (shrinking) a field.
		 * @param {Ext.form.Field} field
		 * @param {Number} new width
		 * @param {Nexts.plugins.FieldAutoExpand} plugin object
		 */
		 'autoexpand',
 
		 /**
		 * @event beforeautoexpand
		 * Fires just before field is auto expanded (shrunk). Return false to stop expanding.
		 * @param {Ext.form.Field} field
		 * @param {Number} new width
		 * @param {Nexts.plugins.FieldAutoExpand} plugin object
		 */
		 'beforeautoexpand'
	);
 
	Nexts.plugins.FieldAutoExpand.superclass.constructor.call(this);
};
 
Ext.extend(Nexts.plugins.FieldAutoExpand, Ext.util.Observable, {
	/**
	 * @cfg {Number} offsetFix	Amount of pixels to add (substract) due to elements offset.
	 */
	offsetFix: -10,
 
	/**
	 * @cfg {Number} labelOffsetFix Amount of pixels to add (substract) when label is visible.
	 */
	labelOffsetFix: -5,
 
	/**
	 * @cfg {Number} sideMsgFix Amount of pixels to add (substract) for the field validation icon
	 */
	sideMsgFix: -25,
 
	/**
	 * @cfg {Number} FieldAutoExpand Maximum field width
	 */
	autoExpandMax: 0,
 
 
	// methods
	/**
	 * Init function
	 * @param {Ext.form.FormPanel} formPanel Parent panel for this plugin
	 */
	init:function(formPanel) {
		this.panel = formPanel;
		this.form = this.panel.getForm();
		this.autoWidthFields = [];
		this.panel.on('afterlayout',this.init2,this,{single:true});
		this.panel.on('add',this.init2,this);
		this.panel.on('remove',this.init2,this);

	},

	/**
	 * Scans fields and prepares listener
	 * @private
	 */
	init2:function(){
		this.autoWidthFields = [];
		this.form.items.each(function(f){
			if((f.width == 'auto' || !f.width) && !f.grow)
				this.autoWidthFields[this.autoWidthFields.length] = f;
		},this);
 
		// Adjusts field widths when laying out elements.
		this.panel.on('afterlayout',this.fitWidths,this);
	},

	/**
	 * Adjusts field widths.
	 * @private
	 */
	fitWidths:function() {
		Ext.each(this.autoWidthFields,function(f){
			if(!this.width1){
				// field width if the label is hidden
				this.width4 = this.form.getEl().down('.x-form-item').getSize(true).width + this.offsetFix;
 
				// field width if the label is hidden and there is validation icon on the side
				this.width3 = this.width4 + this.sideMsgFix;
 
				// field width if the label is visible
				this.width2 = this.width4 - this.panel.labelWidth + this.labelOffsetFix;//
 
				// field width if the label is visible and we have validation icon on the side
				this.width1 = this.width2 + this.sideMsgFix;			
			}
 
			if(!f.hideLabel){	
				if(f.msgTarget == 'side')
					var width = this.width1;
				else
					var width = this.width2;
			}else{
				if(f.msgTarget == 'side')
					var width = this.width3;
				else
					var width = this.width4;
			}
 
			if(this.autoExpandMax && width > this.autoExpandMax)
				width = this.autoExpandMax;
			if(f.autoExpandMax && width > f.autoExpandMax)
				width = f.autoExpandMax;
 
			if(true !== this.eventsSuspended && false === this.fireEvent('beforeautoexpand', f, width,this)) {
				return;
			}else{
				f.setWidth(width);
				this.fireEvent('autoexpand', f, width,this);
			}
		},this);
 
		this.width1 = 0;
	}
});

