Ext.ns('Nexts.layout');

Nexts.layout.LineLayout = Ext.extend(Ext.layout.ContainerLayout, {
	cellCls: 'ne-top',
	
	onLayout: function(ct, target) {
		var cs = ct.items.items, len = cs.length, c, i;

		if (this.line) {
			var cns = this.line.dom.childNodes;
			var ems = [];
			
			for (var i = 0; i < cns.length; i++) {
				if (!cns[i].firstChild) {
					ems.push(cns[i]);
				}
			}
			for (var i = 0; i < ems.length; i++) {
				Ext.removeNode(ems[i]);
			}
		}
		else {
			target.addClass('ne-line-layout-ct');

			var div = target.createChild({
				tag: 'div',
				cls: 'ne-line-layout'
			});
			var table = div.createChild({
				tag: 'table', 
				cls:'ne-line-layout-table',
				boder: 0,
				cellpadding: 0,
				cellspacing: 0,
				html: '<tbody><tr></tr></tbody>'
			});
			
			this.line = table.child('tr');
		}
		this.renderAll(ct, target);
	},
	
	// private
	renderItem: function(c, position, target) {
		if (c && !c.rendered) {
			var td = document.createElement('td');
			if (c.cellId) {
				td.id = c.cellId;
			}
			var cls = 'ne-line-layout-cell';
			if (c.cellCls) {
				cls += ' ' + c.cellCls;
			}
			else if (this.cellCls) {
				cls += ' ' + this.cellCls;
			}
			td.className = cls;
			
			if (position >= this.line.dom.childNodes.length) {
				this.line.appendChild(td);
			}
			else {
				this.line.dom.insertBefore(td, this.line.dom.childNodes[position]);
			}
			c.render(td);
		}
	},

	// private
	isValidParent : function(c, target) {
		return true;
	}


});
Ext.Container.LAYOUTS['n.line'] = Nexts.layout.LineLayout;

