Ext.ns('Nexts.grid');

Nexts.grid.RowDeleted = function(config) {
	Ext.apply(this, config);

	this.renderer = this.renderer.createDelegate(this);
};

Ext.apply(Nexts.grid.RowDeleted.prototype, {
	id: 'deleted',
	
	align: 'center',
	
	deletedValue: true,

	deletedText: '\u25cb',
	
	width: 40,
	
	rowCls: 'ne-grid-row-deleted',
	
	isDeletedRecord: function(record) {
		if (Ext.isEmpty(this.dataIndex)) {
			return false;
		}
		
		if (record.data && record.data[this.dataIndex] == this.deletedValue) {
			return true;
		}
		
		return false;
	},
	
	getRowClass: function(record, rowIndex, p, ds) {
		var cls = '';
		
		if (typeof this.saveGetRowClass == 'function') {
			cls = this.saveGetRowClass.apply(this.grid.view, arguments);
		}

		if (this.isDeletedRecord(record)) {
			return cls + ' ' + this.rowCls;
		}
		
		return cls;
	},

	init: function(grid) {
		this.grid = grid;

		var view = grid.getView();

		this.saveGetRowClass = view.getRowClass;
		
		view.getRowClass = this.getRowClass.createDelegate(this);
	},

	renderer: function(v, p, record) {
		if (p && this.rowspan) {
			p.cellAttr = 'rowspan="' + this.rowspan + '"';
		}

 		return (v == this.deletedValue ? this.deletedText : '');
	}

});

