Ext.ns('Nexts.form');

Nexts.form.FormPanel = function(config) {

	config = config || {};
	
	Ext.applyIf(config, {waitMsgTarget: !Ext.isIE7});

	config.plugins = config.plugins || [];

	for (var i = 0; i < config.plugins.length; i++) {
		var p = config.plugins[i];
		if (p instanceof Nexts.form.FormMessages) {
			this.formMessages = p;
		}
		if (p instanceof Nexts.form.FormKeyControl) {
			this.formKeyControl = p;
		}
		if (p instanceof Nexts.form.FormBtnControl) {
			this.formBtnControl = p;
		}
	}
	if (!this.formMessages) {
		this.formMessages = new Nexts.form.FormMessages();
		config.plugins.push(this.formMessages);
	}
	if (!this.formKeyControl) {
		this.formKeyControl = new Nexts.form.FormKeyControl();
		config.plugins.push(this.formKeyControl);
	}
	if (!this.formBtnControl) {
		this.formBtnControl = new Nexts.form.FormBtnControl();
		config.plugins.push(this.formBtnControl);
	}

	// call parent
	Nexts.form.FormPanel.superclass.constructor.call(this, config);
};

Ext.extend(Nexts.form.FormPanel, Ext.form.FormPanel, {
	xtype: 'n.form',
	
	clayout: 'column',
	
	clayoutConfig: {
		columns: 1
	},
	
	initComponent: function() {
		switch (this.clayout) {
		case 'column':
			this.columnLayoutItems();
			break;
		case 'table':
			this.tableLayoutItems();
			break;
		}
		
		// call parent
		Nexts.form.FormPanel.superclass.initComponent.call(this);
	},
	
	isActionProcessing: function() {
		return this.form.activeAction != null;
	},
	
	load: function() {
		this.form.load.apply(this.form, arguments);
	},

	submit: function() {
		this.form.submit.apply(this.form, arguments);
	},

	subload: function() {
		this.form.subload.apply(this.form, arguments);
	},

	setFocusItem: function(item) {
		var f = this.getForm().items.item(item);
		if (f) {
			f.focus();
		}
	},

	addPatchToItem: function(e) {
		if (Ext.isIE) {
			if (e.xtype == 'checkbox') {
				delete e.width;
			}
		}
	},
		
	columnLayoutItems: function() {
		var cs = this.clayoutConfig.columns || 1;
		
		var cl = {
			xtype: 'panel',
			stateful: this.stateful,
			layout: 'column',
			border: false,
			autoHeight: true,
			items: []
		};
		
		for (var i = 0; i < cs; i++) {
			cl.items.push({
				xtype: 'panel',
				stateful: this.stateful,
				layout: 'form',
				columnWidth: 1 / cs,
				autoHeight: true,
				border: false,
				items: []
			});
		}

		this.defaults = Ext.applyIf(this.defaults || {}, { xtype: 'textfield' });
		
		var ci = 0;
		var its = this.items;
		for (var i = 0; i < its.length; i++) {
			var e = its[i];
			
			Ext.applyIf(e, this.defaults);
			
			cl.items[ci++].items.push(e);
			ci = ci === cs ? 0 : ci;

			this.addPatchToItem(e);
		}
		
		delete this.defaults;
		delete this.defaultType;
		
		this.items = [ cl ];
		
		return its;
	},
	
	tableLayoutItems: function() {
		var cs = this.clayoutConfig.columns || 1;
		
		var cl = {
			xtype: 'panel',
			stateful: this.stateful,
			layout: 'table',
			border: false,
			layoutConfig: {
				columns: cs
			},
			autoHeight: true,
			items: []
		};
		
		this.defaults = Ext.applyIf(this.defaults || {}, { xtype: 'textfield' });
		
		var its = this.items;
		for (var i = 0; i < its.length; i++) {
			var e = its[i];
			Ext.applyIf(e, this.defaults);

			cl.items.push({
				xtype: 'panel',
				stateful: this.stateful,
				layout: 'form',
				autoHeight: true,
				border: false,
				rowspan: e.rowspan,
				colspan: e.colspan,
				cellId: e.cellId,
				cellCls: e.cellCls ? e.cellCls : 'ne-top',
				items: [ e ]
			});

			this.addPatchToItem(e);
		}
		
		delete this.defaults;
		delete this.defaultType;
		
		this.items = [ cl ];
		
		return its;
	},
	
	tabtifyItems: function(its) {
		for (var i = 0; i < its.length; i++) {
			Ext.applyIf(its[i], { tabIndex: i + 1 });
		}
	}
});

Ext.reg('n.form', Nexts.form.FormPanel);
