Ext.ns('Nexts.form');

Nexts.form.FormMessages = function(config) {
	config = config || {};
	
	config.border = false;
	
	// call parent
	Nexts.form.FormMessages.superclass.constructor.call(this, config);
};

Ext.extend(Nexts.form.FormMessages, Ext.Panel, {
	clientInvalidText	:	'Client form input invalid.',
	connectFailureText	:	'Server connection failure.',
	loadFailureText		:	'Can not load response from server.',
	serverInvalidText	:	'Server process error.',
	unknownFailureText	:	'Unknown failure.',
	
	detailTooltip		:	'Detail information',

	onActionComplete: function(form, action) {
		this.processActionResult(form, action);
	},
	
	onActionFailed: function(form, action) {
		switch (action.failureType) {
		case Ext.form.Action.CLIENT_INVALID:
			this.onActionClientInvalid(form, action);
			break;
		case Ext.form.Action.CONNECT_FAILURE:
			this.onActionConnectFailure(form, action);
			break;
		case Ext.form.Action.LOAD_FAILURE:
			this.onActionLoadFailure(form, action);
			break;
		case Ext.form.Action.SERVER_INVALID:
			this.onActionServerInvalid(form, action);
			break;
		default:
			this.onActionUnknownFailure(form, action);
			break;
		}
	},
	
	onActionClientInvalid: function(form, action) {
		this.addError(this.clientInvalidText);
	},
	
	onActionConnectFailure: function(form, action) {
		this.addError(this.connectFailureText, action);
	},
	
	onActionLoadFailure: function(form, action) {
		this.addError(this.loadFailureText, action);
	},
	
	onActionServerInvalid: function(form, action) {
		if (this.processActionResult(form, action) < 1) {
			this.addError(this.serverInvalidText, action);
		}
	},
	
	processActionResult: function(form, action) {
		var msgCount = 0;
		if (action.result) {
			if (action.result.actionErrors) {
				var aes = action.result.actionErrors;
				for (var i = 0, len = aes.length; i < len; i++) {
					this.addError(aes[i]);
					msgCount++;
				}
			}
			if (action.result.actionWarnings) {
				var aws = action.result.actionWarnings;
				for (var i = 0, len = aws.length; i < len; i++) {
					this.addWarn(aws[i]);
					msgCount++;
				}
			}
			if (action.result.actionMessages) {
				var ams = action.result.actionMessages;
				for (var i = 0, len = ams.length; i < len; i++) {
					this.addInfo(ams[i]);
					msgCount++;
				}
			}
			if (action.result.fieldErrors) {
				this.addError(this.clientInvalidText);
				msgCount++;
			}
		}

		return msgCount;
	},
	
	onActionUnknownFailure: function(form, action) {
		this.addError(this.unknownFailureText);
	},
	
	onBeforeAction: function(form, action) {
		this.clearMessages();
	},
	
	init: function(form) {
		this.form = form;
		
		form.on({
			actioncomplete: this.onActionComplete,
			actionfailed: this.onActionFailed,
			beforeaction: this.onBeforeAction,
			scope: this
		});
		form.afterRender = form.afterRender.createSequence(this.renderToForm, this);
	},
	
	renderToForm: function() {
		this.render(this.form.body.parent(), this.form.body.dom);
	},
	
	// private
	onDestroy : function() {
		this.clearMessages();
		Nexts.form.FormMessages.superclass.onDestroy.call(this);
	},

	// public
	clearMessages: function() {
		if (this.detailPopup) {
			this.detailPopup.destroy();
			delete this.detailPopup;
		}
		if (this.detailTrigger) {
			Ext.destroy(this.detailTrigger);
			delete this.detailTrigger;
		}
		if (this.msgCt) {
			Ext.destroy(this.msgCt);
			delete this.msgCt;
		}
	},
	
	onDetailTrigger: function(e) {
		e.stopEvent();
		this.detailPopup.show(this.detailTrigger, "tr-br?");
	},
	
	createDetailTools: function(action) {
		if (!this.detailTrigger) {
			this.detailTrigger = Ext.DomHelper.insertFirst(this.msgCt, {
				tag: 'div',
				qtip: this.detailTooltip,	
				cls: 'ne-formmsg-detail-trigger'
			}, true);
			
			this.detailTrigger.on({
				click: this.onDetailTrigger,
				scope: this
			});
		}
		
		if (!this.detailPopup) {
			this.detailPopup = new Nexts.AjaxResponsePopup({
				action: action,
				response: action.response,
				result: action.result
			});
		}
	},
	
	// public
	addMessage: function(type, msg, action) {
		if (Ext.isEmpty(msg)) {
			return;
		}
		
		if (!this.msgCt) {
			this.msgCt = this.body.createChild({
				tag: 'div',
				cls: 'ne-formmsg-container'
			});

			if (action) {
				this.createDetailTools(action);
			}
		}
		this.msgCt.createChild({
			tag: 'div',
			cls: 'ne-formmsg-msg ne-formmsg-msg-' + type,
			html: '<span>' + msg + '</span>'
		});
	},
	
	// public
	addInfo: function(msg, action) {
		this.addMessage(Nexts.form.FormMessages.MT_INFO, msg, action);
	},

	// public
	addWarn: function(msg, action) {
		this.addMessage(Nexts.form.FormMessages.MT_WARN, msg, action);
	},
	
	// public
	addError: function(msg, action) {
		this.addMessage(Nexts.form.FormMessages.MT_ERROR, msg, action);
	},
	
	// public
	addConfirm: function(msg, action) {
		this.addMessage(Nexts.form.FormMessages.MT_CONFIRM, msg, action);
	}
});

Ext.apply(Nexts.form.FormMessages, {
	"MT_INFO": "info",
	"MT_WARN": "warn",
	"MT_ERROR": "error",
	"MT_CONFIRM": "confirm"
});
